/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.data;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.xiyu.spartanshieldsunofficial.init.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "spartanshieldsunofficial", existingFileHelper);
    }

    protected void registerModels() {
        List.of(ModItems.WOODEN_BASIC_SHIELD, ModItems.STONE_BASIC_SHIELD, ModItems.COPPER_BASIC_SHIELD, ModItems.IRON_BASIC_SHIELD, ModItems.GOLDEN_BASIC_SHIELD, ModItems.DIAMOND_BASIC_SHIELD, ModItems.NETHERITE_BASIC_SHIELD, ModItems.OBSIDIAN_BASIC_SHIELD, ModItems.TIN_BASIC_SHIELD, ModItems.BRONZE_BASIC_SHIELD, ModItems.STEEL_BASIC_SHIELD, ModItems.SILVER_BASIC_SHIELD, ModItems.ELECTRUM_BASIC_SHIELD, ModItems.LEAD_BASIC_SHIELD, ModItems.NICKEL_BASIC_SHIELD, ModItems.INVAR_BASIC_SHIELD, ModItems.CONSTANTAN_BASIC_SHIELD, ModItems.PLATINUM_BASIC_SHIELD, ModItems.ALUMINUM_BASIC_SHIELD, ModItems.SIGNALUM_BASIC_SHIELD, ModItems.LUMIUM_BASIC_SHIELD, ModItems.ENDERIUM_BASIC_SHIELD).forEach(shield -> this.createBasicShieldModel((Item)shield.get()));
        List.of(ModItems.MANASTEEL_BASIC_SHIELD, ModItems.TERRASTEEL_BASIC_SHIELD, ModItems.ELEMENTIUM_BASIC_SHIELD).forEach(shield -> this.createModdedBasicShieldModel((Item)shield.get(), "botania"));
        List.of(ModItems.LAPIS_BASIC_SHIELD, ModItems.OSMIUM_BASIC_SHIELD, ModItems.REFINED_GLOWSTONE_BASIC_SHIELD, ModItems.REFINED_OBSIDIAN_BASIC_SHIELD).forEach(shield -> this.createModdedBasicShieldModel((Item)shield.get(), "mekanism"));
        List.of(ModItems.BASIC_MEKANISTS_BASIC_SHIELD, ModItems.ADVANCED_MEKANISTS_BASIC_SHIELD, ModItems.ELITE_MEKANISTS_BASIC_SHIELD, ModItems.ULTIMATE_MEKANISTS_BASIC_SHIELD).forEach(shield -> this.createMekanismPoweredBasicShieldModel((Item)shield.get()));
        this.createEnderIOPoweredBasicShieldModel((Item)ModItems.DARK_STEEL_RIOT_BASIC_SHIELD.get());
        List.of(ModItems.WOODEN_TOWER_SHIELD, ModItems.STONE_TOWER_SHIELD, ModItems.COPPER_TOWER_SHIELD, ModItems.IRON_TOWER_SHIELD, ModItems.GOLDEN_TOWER_SHIELD, ModItems.DIAMOND_TOWER_SHIELD, ModItems.NETHERITE_TOWER_SHIELD, ModItems.OBSIDIAN_TOWER_SHIELD, ModItems.TIN_TOWER_SHIELD, ModItems.BRONZE_TOWER_SHIELD, ModItems.STEEL_TOWER_SHIELD, ModItems.SILVER_TOWER_SHIELD, ModItems.ELECTRUM_TOWER_SHIELD, ModItems.LEAD_TOWER_SHIELD, ModItems.NICKEL_TOWER_SHIELD, ModItems.INVAR_TOWER_SHIELD, ModItems.CONSTANTAN_TOWER_SHIELD, ModItems.PLATINUM_TOWER_SHIELD, ModItems.ALUMINUM_TOWER_SHIELD, ModItems.SIGNALUM_TOWER_SHIELD, ModItems.LUMIUM_TOWER_SHIELD, ModItems.ENDERIUM_TOWER_SHIELD, ModItems.MANASTEEL_TOWER_SHIELD, ModItems.TERRASTEEL_TOWER_SHIELD, ModItems.ELEMENTIUM_TOWER_SHIELD, ModItems.BASIC_MEKANISTS_TOWER_SHIELD, ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD, ModItems.ELITE_MEKANISTS_TOWER_SHIELD, ModItems.ULTIMATE_MEKANISTS_TOWER_SHIELD, ModItems.DARK_STEEL_RIOT_TOWER_SHIELD).forEach(shield -> this.createTowerShieldModel((Item)shield.get()));
    }

    protected ResourceLocation createBasicShieldModel(Item itemIn) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath();
        ModelBuilder blockingModel = ((ItemModelBuilder)this.withExistingParent(itemPath + "_blocking", ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base_blocking"))).texture("layer0", "item/" + itemPath);
        return ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base"))).texture("layer0", "item/" + itemPath)).override().predicate(ResourceLocation.parse((String)"blocking"), 1.0f).model((ModelFile)blockingModel).end().getLocation();
    }

    protected ResourceLocation createModdedBasicShieldModel(Item itemIn, String modId) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath();
        ModelBuilder blockingModel = ((ItemModelBuilder)this.withExistingParent(itemPath + "_blocking", ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base_blocking"))).texture("layer0", "item/" + modId + "/" + itemPath);
        return ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base"))).texture("layer0", "item/" + modId + "/" + itemPath)).override().predicate(ResourceLocation.parse((String)"blocking"), 1.0f).model((ModelFile)blockingModel).end().getLocation();
    }

    protected ResourceLocation createMekanismPoweredBasicShieldModel(Item itemIn) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath();
        ModelFile.ExistingModelFile blockingModel = this.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"mekanists_basic_shield_base_blocking"));
        ModelFile.ExistingModelFile deactivatedModel = this.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"mekanists_basic_shield_base_deactivated"));
        ModelFile.ExistingModelFile deactivatedBlockingModel = this.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"mekanists_basic_shield_base_deactivated_blocking"));
        ResourceLocation disabled = ResourceLocation.parse((String)"disabled");
        ResourceLocation blocking = ResourceLocation.parse((String)"blocking");
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"mekanists_basic_shield_base"))).texture("layer0", "item/mekanism/mekanists_basic_shield_base")).texture("layer1", "item/mekanism/mekanists_basic_shield_lights_on")).override().predicate(disabled, 0.0f).predicate(blocking, 1.0f).model((ModelFile)blockingModel).end().override().predicate(disabled, 1.0f).predicate(blocking, 0.0f).model((ModelFile)deactivatedModel).end().override().predicate(disabled, 1.0f).predicate(blocking, 1.0f).model((ModelFile)deactivatedBlockingModel).end().getLocation();
    }

    protected ResourceLocation createEnderIOPoweredBasicShieldModel(Item itemIn) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath();
        String baseTexture = "item/enderio/" + itemPath + "_base";
        String activatedTexture = "item/enderio/" + itemPath + "_activated";
        String deactivatedTexture = "item/enderio/" + itemPath + "_deactivated";
        ModelBuilder blockingModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath + "_blocking", ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base_blocking"))).texture("layer0", baseTexture)).texture("layer1", activatedTexture);
        ModelBuilder deactivatedModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath + "_deactivated", ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base"))).texture("layer0", baseTexture)).texture("layer1", deactivatedTexture);
        ModelBuilder deactivatedBlockingModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath + "_deactivated_blocking", ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base_blocking"))).texture("layer0", baseTexture)).texture("layer1", deactivatedTexture);
        ResourceLocation disabled = ResourceLocation.parse((String)"disabled");
        ResourceLocation blocking = ResourceLocation.parse((String)"blocking");
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"basic_shield_base"))).texture("layer0", baseTexture)).texture("layer1", activatedTexture)).override().predicate(disabled, 0.0f).predicate(blocking, 1.0f).model((ModelFile)blockingModel).end().override().predicate(disabled, 1.0f).predicate(blocking, 0.0f).model((ModelFile)deactivatedModel).end().override().predicate(disabled, 1.0f).predicate(blocking, 1.0f).model((ModelFile)deactivatedBlockingModel).end().getLocation();
    }

    protected ResourceLocation createTowerShieldModel(Item itemIn) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath();
        ModelFile.ExistingModelFile blockingModel = this.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"tower_shield_base_blocking"));
        return ((ItemModelBuilder)this.withExistingParent(itemPath, ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"tower_shield_base"))).override().predicate(ResourceLocation.parse((String)"blocking"), 1.0f).model((ModelFile)blockingModel).end().getLocation();
    }

    public String getName() {
        return "Spartan Shields Unofficial Item Models";
    }
}

