/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.xiyu.spartanshieldsunofficial.crafting.condition.TypeDisabledCondition;
import org.xiyu.spartanshieldsunofficial.data.ConditionalShapedRecipeBuilder;
import org.xiyu.spartanshieldsunofficial.init.ModItems;
import org.xiyu.spartanshieldsunofficial.item.ShieldBaseItem;
import org.xiyu.spartanshieldsunofficial.item.crafting.PoweredShieldUpgradeRecipe;
import org.xiyu.spartanshieldsunofficial.item.crafting.ShieldBannerRecipeBuilder;

public class ModRecipeProvider
extends RecipeProvider {
    private RecipeOutput output;

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.output = output;
        TagKey planks = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:planks"));
        TagKey stick = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:rods/wooden"));
        TagKey cobblestone = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:cobblestones"));
        TagKey copperIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/copper"));
        TagKey ironIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/iron"));
        TagKey goldIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/gold"));
        TagKey diamond = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:gems/diamond"));
        TagKey netheriteIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/netherite"));
        TagKey obsidian = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:obsidians"));
        TagKey tinIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/tin"));
        TagKey bronzeIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/bronze"));
        TagKey steelIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/steel"));
        TagKey silverIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/silver"));
        TagKey electrumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/electrum"));
        TagKey leadIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/lead"));
        TagKey nickelIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/nickel"));
        TagKey invarIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/invar"));
        TagKey constantanIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/constantan"));
        TagKey platinumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/platinum"));
        TagKey aluminumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/aluminum"));
        TagKey manasteelIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/manasteel"));
        TagKey terrasteelIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/terrasteel"));
        TagKey elementiumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/elementium"));
        TagKey osmiumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/osmium"));
        TagKey lapis = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:gems/lapis"));
        TagKey refinedGlowstoneIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/refined_glowstone"));
        TagKey refinedObsidianIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/refined_obsidian"));
        TagKey signalumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/signalum"));
        TagKey lumiumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/lumium"));
        TagKey enderiumIngot = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/enderium"));
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.WOODEN_BASIC_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)planks).define(Character.valueOf('/'), (TagKey<Item>)stick).pattern(" # ").pattern("#/#").pattern(" # ").group("spartanshieldsunofficial:wood_shields").unlockedBy("has_planks", this.hasItem((TagKey<Item>)planks)).save(output);
        ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.WOODEN_TOWER_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)planks).define(Character.valueOf('/'), (TagKey<Item>)stick).pattern("###").pattern("#/#").pattern(" # ").group("spartanshieldsunofficial:wood_shields").unlockedBy("has_planks", this.hasItem((TagKey<Item>)planks)).save(output);
        this.basicUpgradeRecipe((ItemLike)ModItems.STONE_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)cobblestone, "stone_shields", "has_cobblestone");
        this.towerUpgradeRecipe((ItemLike)ModItems.STONE_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)cobblestone, "stone_shields", "has_cobblestone");
        this.basicUpgradeRecipe((ItemLike)ModItems.COPPER_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)copperIngot, "copper_shields", "has_copper_ingot");
        this.towerUpgradeRecipe((ItemLike)ModItems.COPPER_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)copperIngot, "copper_shields", "has_copper_ingot");
        this.basicUpgradeRecipe((ItemLike)ModItems.IRON_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)ironIngot, "iron_shields", "has_iron_ingot");
        this.towerUpgradeRecipe((ItemLike)ModItems.IRON_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)ironIngot, "iron_shields", "has_iron_ingot");
        this.basicUpgradeRecipe((ItemLike)ModItems.GOLDEN_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)goldIngot, "gold_shields", "has_gold_ingot");
        this.towerUpgradeRecipe((ItemLike)ModItems.GOLDEN_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)goldIngot, "gold_shields", "has_gold_ingot");
        this.basicUpgradeRecipe((ItemLike)ModItems.DIAMOND_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)diamond, "diamond_shields", "has_diamond");
        this.towerUpgradeRecipe((ItemLike)ModItems.DIAMOND_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)diamond, "diamond_shields", "has_diamond");
        this.smithingRecipe((ItemLike)ModItems.NETHERITE_BASIC_SHIELD.get(), (ItemLike)ModItems.DIAMOND_BASIC_SHIELD.get(), (TagKey<Item>)netheriteIngot, "has_netherite_ingot");
        this.smithingRecipe((ItemLike)ModItems.NETHERITE_TOWER_SHIELD.get(), (ItemLike)ModItems.DIAMOND_TOWER_SHIELD.get(), (TagKey<Item>)netheriteIngot, "has_netherite_ingot");
        this.conditionalUpgradeRecipe((ItemLike)ModItems.OBSIDIAN_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)obsidian, "obsidian_shields", "has_obsidian", "obsidian", false);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.OBSIDIAN_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)obsidian, "obsidian_shields", "has_obsidian", "obsidian", false);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.TIN_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)tinIngot, "tin_shields", "has_tin_ingot", "tin", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.TIN_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)tinIngot, "tin_shields", "has_tin_ingot", "tin", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.BRONZE_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)bronzeIngot, "bronze_shields", "has_bronze_ingot", "bronze", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.BRONZE_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)bronzeIngot, "bronze_shields", "has_bronze_ingot", "bronze", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.STEEL_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)steelIngot, "steel_shields", "has_steel_ingot", "steel", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.STEEL_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)steelIngot, "steel_shields", "has_steel_ingot", "steel", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.SILVER_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)silverIngot, "silver_shields", "has_silver_ingot", "silver", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.SILVER_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)silverIngot, "silver_shields", "has_silver_ingot", "silver", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.ELECTRUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)electrumIngot, "electrum_shields", "has_electrum_ingot", "electrum", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.ELECTRUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)electrumIngot, "electrum_shields", "has_electrum_ingot", "electrum", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.LEAD_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)leadIngot, "lead_shields", "has_lead_ingot", "lead", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.LEAD_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)leadIngot, "lead_shields", "has_lead_ingot", "lead", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.NICKEL_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)nickelIngot, "nickel_shields", "has_nickel_ingot", "nickel", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.NICKEL_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)nickelIngot, "nickel_shields", "has_nickel_ingot", "nickel", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.INVAR_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)invarIngot, "invar_shields", "has_invar_ingot", "invar", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.INVAR_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)invarIngot, "invar_shields", "has_invar_ingot", "invar", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.CONSTANTAN_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)constantanIngot, "constantan_shields", "has_constantan_ingot", "constantan", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.CONSTANTAN_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)constantanIngot, "constantan_shields", "has_constantan_ingot", "constantan", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.PLATINUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)platinumIngot, "platinum_shields", "has_platinum_ingot", "platinum", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.PLATINUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)platinumIngot, "platinum_shields", "has_platinum_ingot", "platinum", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.ALUMINUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)aluminumIngot, "aluminum_shields", "has_aluminum_ingot", "aluminum", true);
        this.conditionalTowerUpgradeRecipe((ItemLike)ModItems.ALUMINUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)aluminumIngot, "aluminum_shields", "has_aluminum_ingot", "aluminum", true);
        if (ModList.get().isLoaded("botania")) {
            Item livingwoodTwig = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:livingwood_twig"));
            Item runeMana = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_mana"));
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.MANASTEEL_BASIC_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)manasteelIngot).define(Character.valueOf('/'), (ItemLike)livingwoodTwig).define(Character.valueOf('e'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_earth"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern("#e#").pattern("#/#").pattern(" m ").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_manasteel_ingot", this.hasItem((TagKey<Item>)manasteelIngot)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.TERRASTEEL_BASIC_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)terrasteelIngot).define(Character.valueOf('/'), (ItemLike)livingwoodTwig).define(Character.valueOf('p'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_pride"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern(" p ").pattern("#/#").pattern(" m ").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_terrasteel_ingot", this.hasItem((TagKey<Item>)terrasteelIngot)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.ELEMENTIUM_BASIC_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)elementiumIngot).define(Character.valueOf('/'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:dreamwood_twig"))).define(Character.valueOf('s'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_summer"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern("#s#").pattern("#/#").pattern(" m ").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_elementium_ingot", this.hasItem((TagKey<Item>)elementiumIngot)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.MANASTEEL_TOWER_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)manasteelIngot).define(Character.valueOf('/'), (ItemLike)livingwoodTwig).define(Character.valueOf('e'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_earth"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern("#e#").pattern("#/#").pattern("#m#").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_manasteel_ingot", this.hasItem((TagKey<Item>)manasteelIngot)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.TERRASTEEL_TOWER_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)terrasteelIngot).define(Character.valueOf('/'), (ItemLike)livingwoodTwig).define(Character.valueOf('p'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_pride"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern("#p#").pattern("#/#").pattern(" m ").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_terrasteel_ingot", this.hasItem((TagKey<Item>)terrasteelIngot)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.ELEMENTIUM_TOWER_SHIELD.get()).define(Character.valueOf('#'), (TagKey<Item>)elementiumIngot).define(Character.valueOf('/'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:dreamwood_twig"))).define(Character.valueOf('s'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"botania:rune_summer"))).define(Character.valueOf('m'), (ItemLike)runeMana).pattern("#s#").pattern("#/#").pattern("#m#").condition((ICondition)new ModLoadedCondition("botania")).unlockedBy("has_elementium_ingot", this.hasItem((TagKey<Item>)elementiumIngot)).save(output);
        }
        this.conditionalModUpgradeRecipe((ItemLike)ModItems.OSMIUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)osmiumIngot, "osmium_shields", "has_osmium_ingot", "mekanism");
        this.conditionalModUpgradeRecipe((ItemLike)ModItems.LAPIS_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)lapis, "lapis_shields", "has_lapis_lazuli", "mekanism");
        this.conditionalModUpgradeRecipe((ItemLike)ModItems.REFINED_GLOWSTONE_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)refinedGlowstoneIngot, "refined_glowstone_shields", "has_refined_glowstone_ingot", "mekanism");
        this.conditionalModUpgradeRecipe((ItemLike)ModItems.REFINED_OBSIDIAN_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)refinedObsidianIngot, "refined_obsidian_shields", "has_refined_obsidian_ingot", "mekanism");
        if (ModList.get().isLoaded("mekanism")) {
            Item energyTablet = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:energy_tablet"));
            Item infusedAlloy = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:alloy_infused"));
            Item reinforcedAlloy = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:alloy_reinforced"));
            Item atomicAlloy = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:alloy_atomic"));
            Item enrichedDiamond = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:enriched_diamond"));
            Item basicControlCircuit = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:basic_control_circuit"));
            Item advancedControlCircuit = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:advanced_control_circuit"));
            Item eliteControlCircuit = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:elite_control_circuit"));
            Item ultimateControlCircuit = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"mekanism:ultimate_control_circuit"));
            this.mekanismShieldRecipe((ItemLike)ModItems.BASIC_MEKANISTS_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), infusedAlloy, enrichedDiamond, basicControlCircuit, energyTablet, (TagKey<Item>)steelIngot);
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ADVANCED_MEKANISTS_BASIC_SHIELD.get(), (ItemLike)ModItems.BASIC_MEKANISTS_BASIC_SHIELD.get(), reinforcedAlloy, advancedControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_basic_mekanists_shield");
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ELITE_MEKANISTS_BASIC_SHIELD.get(), (ItemLike)ModItems.ADVANCED_MEKANISTS_BASIC_SHIELD.get(), atomicAlloy, eliteControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_advanced_mekanists_shield");
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ULTIMATE_MEKANISTS_BASIC_SHIELD.get(), (ItemLike)ModItems.ELITE_MEKANISTS_BASIC_SHIELD.get(), atomicAlloy, ultimateControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_elite_mekanists_shield");
            this.mekanismShieldRecipe((ItemLike)ModItems.BASIC_MEKANISTS_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), infusedAlloy, enrichedDiamond, basicControlCircuit, energyTablet, (TagKey<Item>)steelIngot);
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD.get(), (ItemLike)ModItems.BASIC_MEKANISTS_TOWER_SHIELD.get(), reinforcedAlloy, advancedControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_basic_mekanists_shield");
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ELITE_MEKANISTS_TOWER_SHIELD.get(), (ItemLike)ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD.get(), atomicAlloy, eliteControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_advanced_mekanists_shield");
            this.mekanismShieldUpgradeRecipe((ItemLike)ModItems.ULTIMATE_MEKANISTS_TOWER_SHIELD.get(), (ItemLike)ModItems.ELITE_MEKANISTS_TOWER_SHIELD.get(), atomicAlloy, ultimateControlCircuit, energyTablet, (TagKey<Item>)steelIngot, "has_elite_mekanists_shield");
        }
        if (ModList.get().isLoaded("enderio")) {
            Item octadicCapacitor = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"enderio:octadic_capacitor"));
            Item darkSteelIngot = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"enderio:dark_steel_ingot"));
            Item pulsatingCrystal = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"enderio:pulsating_crystal"));
            Item vibrantCrystal = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"enderio:vibrant_crystal"));
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.DARK_STEEL_RIOT_BASIC_SHIELD.get()).define(Character.valueOf('O'), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get()).define(Character.valueOf('#'), (ItemLike)darkSteelIngot).define(Character.valueOf('c'), (ItemLike)octadicCapacitor).define(Character.valueOf('p'), (ItemLike)pulsatingCrystal).define(Character.valueOf('v'), (ItemLike)vibrantCrystal).pattern("#v#").pattern("cOc").pattern("#p#").condition((ICondition)new ModLoadedCondition("enderio")).unlockedBy("has_octadic_capacitor", this.hasItem((ItemLike)octadicCapacitor)).save(output);
            ConditionalShapedRecipeBuilder.shaped((ItemLike)ModItems.DARK_STEEL_RIOT_TOWER_SHIELD.get()).define(Character.valueOf('O'), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get()).define(Character.valueOf('#'), (ItemLike)darkSteelIngot).define(Character.valueOf('c'), (ItemLike)octadicCapacitor).define(Character.valueOf('p'), (ItemLike)pulsatingCrystal).define(Character.valueOf('v'), (ItemLike)vibrantCrystal).pattern("#v#").pattern("cOc").pattern("#p#").condition((ICondition)new ModLoadedCondition("enderio")).unlockedBy("has_octadic_capacitor", this.hasItem((ItemLike)octadicCapacitor)).save(output);
        }
        this.conditionalUpgradeRecipe((ItemLike)ModItems.SIGNALUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)signalumIngot, "signalum_shields", "has_signalum_ingot", "signalum", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.SIGNALUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)signalumIngot, "signalum_shields", "has_signalum_ingot", "signalum", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.LUMIUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)lumiumIngot, "lumium_shields", "has_lumium_ingot", "lumium", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.LUMIUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)lumiumIngot, "lumium_shields", "has_lumium_ingot", "lumium", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.ENDERIUM_BASIC_SHIELD.get(), (ItemLike)ModItems.WOODEN_BASIC_SHIELD.get(), (TagKey<Item>)enderiumIngot, "enderium_shields", "has_enderium_ingot", "enderium", true);
        this.conditionalUpgradeRecipe((ItemLike)ModItems.ENDERIUM_TOWER_SHIELD.get(), (ItemLike)ModItems.WOODEN_TOWER_SHIELD.get(), (TagKey<Item>)enderiumIngot, "enderium_shields", "has_enderium_ingot", "enderium", true);
        ImmutableList.of((Object)((Object)((ShieldBaseItem)((Object)ModItems.WOODEN_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.STONE_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.COPPER_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.IRON_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.GOLDEN_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.DIAMOND_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.NETHERITE_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.OBSIDIAN_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.TIN_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.BRONZE_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.STEEL_TOWER_SHIELD.get()))), (Object)((Object)((ShieldBaseItem)((Object)ModItems.SILVER_TOWER_SHIELD.get()))), (Object[])new ShieldBaseItem[]{(ShieldBaseItem)((Object)ModItems.ELECTRUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.LEAD_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.NICKEL_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.INVAR_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.CONSTANTAN_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.PLATINUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ALUMINUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.SIGNALUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.LUMIUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ENDERIUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.MANASTEEL_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.TERRASTEEL_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ELEMENTIUM_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.BASIC_MEKANISTS_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ELITE_MEKANISTS_TOWER_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ULTIMATE_MEKANISTS_TOWER_SHIELD.get())}).forEach(shield -> ShieldBannerRecipeBuilder.recipe(shield).save(output));
    }

    private void basicUpgradeRecipe(ItemLike result, ItemLike baseShield, TagKey<Item> material, String group, String unlockName) {
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('O'), baseShield).define(Character.valueOf('#'), material).pattern(" # ").pattern("#O#").pattern(" # ").group("spartanshieldsunofficial:" + group).unlockedBy(unlockName, this.hasItem(material)).save(this.output);
    }

    private void towerUpgradeRecipe(ItemLike result, ItemLike baseShield, TagKey<Item> material, String group, String unlockName) {
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('O'), baseShield).define(Character.valueOf('#'), material).pattern("###").pattern("#O#").pattern(" # ").group("spartanshieldsunofficial:" + group).unlockedBy(unlockName, this.hasItem(material)).save(this.output);
    }

    private void smithingRecipe(ItemLike result, ItemLike base, TagKey<Item> material, String unlockName) {
        ResourceLocation id = ResourceLocation.parse((String)(String.valueOf(BuiltInRegistries.ITEM.getKey((Object)result.asItem())) + "_smithing"));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.of(material), (RecipeCategory)RecipeCategory.MISC, (Item)result.asItem()).unlocks(unlockName, this.hasItem(material)).save(this.output, id);
    }

    private void conditionalUpgradeRecipe(ItemLike result, ItemLike baseShield, TagKey<Item> material, String group, String unlockName, String disabledName, boolean isModded) {
        ImmutableList<String> disableList = this.buildDisableList(disabledName, isModded);
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('O'), baseShield).define(Character.valueOf('#'), material).pattern(" # ").pattern("#O#").pattern(" # ").group("spartanshieldsunofficial:" + group).condition(new TypeDisabledCondition((List<String>)disableList)).condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(material.location()))).unlockedBy(unlockName, this.hasItem(material)).save(this.output);
    }

    private void conditionalTowerUpgradeRecipe(ItemLike result, ItemLike baseShield, TagKey<Item> material, String group, String unlockName, String disabledName, boolean isModded) {
        ImmutableList<String> disableList = this.buildDisableList(disabledName, isModded);
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('O'), baseShield).define(Character.valueOf('#'), material).pattern("###").pattern("#O#").pattern(" # ").group("spartanshieldsunofficial:" + group).condition(new TypeDisabledCondition((List<String>)disableList)).condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(material.location()))).unlockedBy(unlockName, this.hasItem(material)).save(this.output);
    }

    private void conditionalModUpgradeRecipe(ItemLike result, ItemLike baseShield, TagKey<Item> material, String group, String unlockName, String modName) {
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('O'), baseShield).define(Character.valueOf('#'), material).pattern(" # ").pattern("#O#").pattern(" # ").group("spartanshieldsunofficial:" + group).condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"modded"))).condition((ICondition)new ModLoadedCondition(modName)).condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(material.location()))).unlockedBy(unlockName, this.hasItem(material)).save(this.output);
    }

    private void mekanismShieldRecipe(ItemLike result, ItemLike baseShield, Item infusedAlloy, Item enrichedDiamond, Item basicControlCircuit, Item energyTablet, TagKey<Item> steelIngot) {
        ConditionalShapedRecipeBuilder.shaped(result).define(Character.valueOf('a'), (ItemLike)infusedAlloy).define(Character.valueOf('d'), (ItemLike)enrichedDiamond).define(Character.valueOf('c'), (ItemLike)basicControlCircuit).define(Character.valueOf('b'), (ItemLike)energyTablet).define(Character.valueOf('#'), steelIngot).define(Character.valueOf('O'), baseShield).pattern("ada").pattern("bOb").pattern("#c#").condition(new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"modded"))).condition((ICondition)new ModLoadedCondition("mekanism")).unlockedBy("has_energy_tablet", this.hasItem((ItemLike)energyTablet)).save(this.output);
    }

    private void mekanismShieldUpgradeRecipe(ItemLike result, ItemLike baseShield, Item alloy, Item controlCircuit, Item energyTablet, TagKey<Item> steelIngot, String unlockName) {
        RecipeOutput conditionedOutput = this.output.withConditions(new ICondition[]{new TypeDisabledCondition((List<String>)ImmutableList.of((Object)"modded")), new ModLoadedCondition("mekanism")});
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)result.asItem());
        CapturingRecipeOutput capture = new CapturingRecipeOutput();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.asItem()).define(Character.valueOf('a'), (ItemLike)alloy).define(Character.valueOf('c'), (ItemLike)controlCircuit).define(Character.valueOf('O'), baseShield).define(Character.valueOf('b'), (ItemLike)energyTablet).define(Character.valueOf('#'), steelIngot).pattern("a a").pattern("bOb").pattern("#c#").unlockedBy(unlockName, this.hasItem(baseShield)).save((RecipeOutput)capture, id);
        Recipe<?> recipe = capture.recipe;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            conditionedOutput.accept(id, (Recipe)new PoweredShieldUpgradeRecipe(shapedRecipe), capture.advancement);
        }
    }

    private ImmutableList<String> buildDisableList(String disabledName, boolean isModded) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (isModded) {
            listBuilder.add((Object)"modded");
        }
        listBuilder.add((Object)disabledName);
        return listBuilder.build();
    }

    private Criterion<InventoryChangeTrigger.TriggerInstance> hasItem(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)});
    }

    private Criterion<InventoryChangeTrigger.TriggerInstance> hasItem(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item});
    }

    private static class CapturingRecipeOutput
    implements RecipeOutput {
        private Recipe<?> recipe;
        private AdvancementHolder advancement;

        private CapturingRecipeOutput() {
        }

        public Advancement.Builder advancement() {
            return Advancement.Builder.advancement();
        }

        public void includeRootAdvancement() {
        }

        public void accept(ResourceLocation id, Recipe<?> recipe, AdvancementHolder advancement, ICondition ... conditions) {
            this.recipe = recipe;
            this.advancement = advancement;
        }

        public void accept(ResourceLocation id, Recipe<?> recipe, AdvancementHolder advancement) {
            this.recipe = recipe;
            this.advancement = advancement;
        }
    }
}

