/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.event;

import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.xiyu.spartanshieldsunofficial.client.ModKeyBinds;
import org.xiyu.spartanshieldsunofficial.config.Config;
import org.xiyu.spartanshieldsunofficial.network.NetworkHandler;
import org.xiyu.spartanshieldsunofficial.network.ShieldBashPacket;
import org.xiyu.spartanshieldsunofficial.tags.ModItemTags;
import org.xiyu.spartanshieldsunofficial.util.Log;

@EventBusSubscriber(modid="spartanshieldsunofficial", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onMouseInputEvent(InputEvent.MouseButton.Post ev) {
        ClientEventHandler.checkForShieldBash();
    }

    @SubscribeEvent
    public static void onKeyboardInputEvent(InputEvent.Key ev) {
        ClientEventHandler.checkForShieldBash();
    }

    protected static void checkForShieldBash() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (((Boolean)Config.INSTANCE.disableShieldBash.get()).booleanValue() || mc.level == null || mc.screen != null || Minecraft.getInstance().isPaused() || player == null) {
            return;
        }
        if (player.isBlocking()) {
            ItemStack shieldStack = ItemStack.EMPTY;
            InteractionHand shieldHand = null;
            ItemStack usedItem = player.getUseItem();
            if (!(usedItem.is(ModItemTags.SHIELDS_WITH_BASH) && usedItem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && (ModKeyBinds.KEY_ALT_SHIELD_BASH.isUnbound() ? mc.options.keyAttack.consumeClick() : ModKeyBinds.KEY_ALT_SHIELD_BASH.isDown()))) {
                return;
            }
            shieldStack = player.getUseItem();
            shieldHand = player.getUsedItemHand();
            if (player.getCooldowns().isOnCooldown(shieldStack.getItem())) {
                return;
            }
            HitResult result = ClientEventHandler.getEntityMouseOverExtended(mc.player.entityInteractionRange());
            if (result != null) {
                int entId = -1;
                boolean attackEntity = true;
                EntityHitResult entityRayTrace = null;
                if (result instanceof EntityHitResult) {
                    entityRayTrace = (EntityHitResult)result;
                }
                if (entityRayTrace != null && entityRayTrace.getEntity() != null && entityRayTrace.getEntity() != player) {
                    Log.debug("Hit Entity with Shield Bash! - " + entityRayTrace.getEntity().toString());
                    entId = entityRayTrace.getEntity().getId();
                }
                if (entId == -1) {
                    entId = 0;
                    attackEntity = false;
                }
                player.swing(shieldHand, true);
                NetworkHandler.sendPacketToServer(new ShieldBashPacket(shieldHand, entId, attackEntity));
            }
        }
    }

    private static HitResult getEntityMouseOverExtended(double reach) {
        BlockHitResult result = null;
        Minecraft mc = Minecraft.getInstance();
        Entity viewEntity = mc.getCameraEntity();
        if (viewEntity != null && mc.level != null) {
            AABB expBounds;
            double d0 = reach;
            HitResult rayTrace = viewEntity.pick(d0, 0.0f, false);
            Vec3 eyePos = viewEntity.getEyePosition(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (d0 > reach) {
                flag = true;
            }
            d1 *= d1;
            if (rayTrace != null) {
                d1 = rayTrace.getLocation().distanceToSqr(eyePos);
            }
            Vec3 lookVec = viewEntity.getViewVector(1.0f);
            Vec3 attackVec = eyePos.add(lookVec.x * d0, lookVec.y * d0, lookVec.z * d0);
            EntityHitResult entityRayTrace = ProjectileUtil.getEntityHitResult((Entity)viewEntity, (Vec3)eyePos, (Vec3)attackVec, (AABB)(expBounds = viewEntity.getBoundingBox().expandTowards(lookVec.scale(d0)).inflate(1.0, 1.0, 1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)d1);
            if (entityRayTrace != null) {
                Vec3 hitVec = entityRayTrace.getLocation();
                double d2 = eyePos.distanceToSqr(hitVec);
                if (flag && d2 > reach * reach) {
                    result = BlockHitResult.miss((Vec3)hitVec, (Direction)Direction.getNearest((double)lookVec.x, (double)lookVec.y, (double)lookVec.z), (BlockPos)BlockPos.containing((Position)hitVec));
                } else if (d2 < d1 || result == null) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockHitResult.miss((Vec3)attackVec, (Direction)Direction.getNearest((double)lookVec.x, (double)lookVec.y, (double)lookVec.z), (BlockPos)BlockPos.containing((Position)attackVec));
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent ev) {
        ItemStack stack = ev.getItemStack();
        if (!stack.isEmpty() && !((Boolean)Config.INSTANCE.disableShieldBash.get()).booleanValue() && stack.is(ModItemTags.SHIELDS_WITH_BASH) && stack.canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            KeyMapping boundKey = ModKeyBinds.KEY_ALT_SHIELD_BASH.isUnbound() ? Minecraft.getInstance().options.keyAttack : ModKeyBinds.KEY_ALT_SHIELD_BASH;
            ev.getToolTip().add(1, Component.translatable((String)"tooltip.spartanshieldsunofficial.shield_bash", (Object[])new Object[]{Component.translatable((String)"tooltip.spartanshieldsunofficial.shield_bash.value", (Object[])new Object[]{Component.translatable((String)boundKey.getTranslatedKeyMessage().getString().toUpperCase()).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.GOLD));
        }
    }
}

