/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.event;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.xiyu.spartanshieldsunofficial.init.ModDataComponents;
import org.xiyu.spartanshieldsunofficial.init.ModEnchantments;
import org.xiyu.spartanshieldsunofficial.init.ModSounds;
import org.xiyu.spartanshieldsunofficial.item.IDamageShield;
import org.xiyu.spartanshieldsunofficial.item.ShieldBaseItem;
import org.xiyu.spartanshieldsunofficial.util.EnchantmentConstants;

@EventBusSubscriber(modid="spartanshieldsunofficial")
public class CommonEventHandler {
    @SubscribeEvent
    public static void attackEvent(LivingDamageEvent.Pre ev) {
        float damage = ev.getOriginalDamage();
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Entity directEntity = ev.getSource().getDirectEntity();
            if (!player.getUseItem().isEmpty() && player.getUseItem().getItem() instanceof ShieldBaseItem && ev.getSource().getDirectEntity() != null) {
                int paybackLevel;
                ItemStack activeStack = player.getUseItem();
                Entity attacker = ev.getSource().getEntity();
                int spikesLevel = EnchantmentHelper.getItemEnchantmentLevel(CommonEventHandler.getEnchantmentHolder(player, ModEnchantments.SPIKES), (ItemStack)activeStack);
                if (spikesLevel > 0 && attacker instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    CommonEventHandler.handleSpikesEnchantment(player, livingAttacker, spikesLevel);
                }
                if ((paybackLevel = EnchantmentHelper.getItemEnchantmentLevel(CommonEventHandler.getEnchantmentHolder(player, ModEnchantments.PAYBACK), (ItemStack)activeStack)) > 0) {
                    CommonEventHandler.handlePaybackEnchantment(player, activeStack, damage, paybackLevel);
                }
                if (damage >= 3.0f && !activeStack.isEmpty() && activeStack.getItem() instanceof IDamageShield && directEntity instanceof LivingEntity) {
                    ((IDamageShield)activeStack.getItem()).damageShield(activeStack, player, (Entity)((LivingEntity)directEntity), damage);
                }
            }
        }
    }

    private static Holder<Enchantment> getEnchantmentHolder(Player player, ResourceKey<Enchantment> key) {
        return player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
    }

    private static void handleSpikesEnchantment(Player user, LivingEntity attacker, int level) {
        float spikeDamage = 1.0f + (float)level * 0.5f;
        attacker.hurt(user.damageSources().thorns((Entity)user), spikeDamage);
    }

    private static void handlePaybackEnchantment(Player user, ItemStack activeStack, float damage, int level) {
        float currentDmg = ((Float)activeStack.getOrDefault((DataComponentType)ModDataComponents.PAYBACK_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue();
        float maxDmg = EnchantmentConstants.getPaybackMaxDamageCapacity(level);
        float absorbedDmg = damage * EnchantmentConstants.getPaybackAbsorbedDamageRatio();
        currentDmg = Mth.clamp((float)(currentDmg + absorbedDmg), (float)0.0f, (float)maxDmg);
        activeStack.set((DataComponentType)ModDataComponents.PAYBACK_DAMAGE.get(), (Object)Float.valueOf(currentDmg));
        if (currentDmg >= maxDmg) {
            user.level().playSound((Player)null, user.getX(), user.getY(), user.getZ(), (SoundEvent)ModSounds.SHIELD_PAYBACK_CHARGE.get(), user.getSoundSource(), 0.5f, 2.0f);
        }
    }
}

