/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import org.xiyu.spartanshieldsunofficial.client.ClientHelper;
import org.xiyu.spartanshieldsunofficial.config.Config;
import org.xiyu.spartanshieldsunofficial.item.ShieldBaseItem;
import org.xiyu.spartanshieldsunofficial.util.TierSS;

public class BasicShieldItem
extends ShieldBaseItem {
    protected final TierSS material;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;

    public BasicShieldItem(TierSS toolMaterial, int defaultMaxDamage, boolean isTowerShieldIn, Item.Properties prop) {
        super(defaultMaxDamage, isTowerShieldIn, prop);
        this.material = toolMaterial;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerShieldPropertyOverrides(this);
        }
    }

    public BasicShieldItem(TierSS toolMaterial, int defaultMaxDamage, Item.Properties prop) {
        this(toolMaterial, defaultMaxDamage, false, prop);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"tooltip.spartanshieldsunofficial.protection", (Object[])new Object[]{this.getMaxDamage(stack)}));
        Level levelIn = context.level();
        if (this.doCraftCheck && levelIn != null) {
            Optional tagOpt;
            if (!((Boolean)Config.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() && ((tagOpt = BuiltInRegistries.ITEM.getTag(this.material.getRepairTag())).isEmpty() || ((HolderSet.Named)tagOpt.get()).size() == 0)) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)Component.translatable((String)String.format("tooltip.%s.uncraftable_missing_material", "spartanshieldsunofficial"), (Object[])new Object[]{this.material.getRepairTagName()}).withStyle(ChatFormatting.RED));
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public int getEnchantmentValue() {
        return this.material.getEnchantmentValue();
    }

    @Override
    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return this.material.getRepairIngredient().test(repair) || super.isValidRepairItem(toRepair, repair);
    }
}

