/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.xiyu.spartanshieldsunofficial.item.BasicShieldItem;
import org.xiyu.spartanshieldsunofficial.item.IDamageShield;
import org.xiyu.spartanshieldsunofficial.util.TierSS;

public class BlockEffectShieldItem
extends BasicShieldItem
implements IDamageShield {
    private final Holder<MobEffect> effect;
    private final int effectTicks;
    private final int effectLevel;

    public BlockEffectShieldItem(TierSS toolMaterial, int defaultMaxDamage, boolean isTowerShieldIn, Holder<MobEffect> effectIn, int effectTicksIn, int effectLevelIn, Item.Properties prop) {
        super(toolMaterial, defaultMaxDamage, isTowerShieldIn, prop);
        this.effect = effectIn;
        this.effectTicks = effectTicksIn;
        this.effectLevel = effectLevelIn;
    }

    public BlockEffectShieldItem(TierSS toolMaterial, int defaultMaxDamage, Holder<MobEffect> effectIn, int effectTicksIn, int effectLevelIn, Item.Properties prop) {
        this(toolMaterial, defaultMaxDamage, false, effectIn, effectTicksIn, effectLevelIn, prop);
    }

    @Override
    public void damageShield(ItemStack shieldStack, Player player, Entity attacker, float damage) {
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            attackerLiving.addEffect(new MobEffectInstance(this.effect, this.effectTicks, this.effectLevel, false, true));
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        MutableComponent effectName = Component.translatable((String)((MobEffect)this.effect.value()).getDescriptionId());
        if (this.effectLevel > 0) {
            effectName = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.translatable((String)("potion.potency." + this.effectLevel))});
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.spartanshieldsunofficial.on_block", (Object[])new Object[]{Component.translatable((String)"tooltip.spartanshieldsunofficial.inflict_mob_effect.desc", (Object[])new Object[]{effectName.withStyle(ChatFormatting.AQUA), Float.valueOf((float)this.effectTicks / 20.0f)}).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.GOLD));
    }
}

