/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import org.xiyu.spartanshieldsunofficial.client.ClientHelper;
import org.xiyu.spartanshieldsunofficial.config.Config;
import org.xiyu.spartanshieldsunofficial.init.ModDataComponents;
import org.xiyu.spartanshieldsunofficial.item.IDamageShield;
import org.xiyu.spartanshieldsunofficial.item.IItemPoweredFE;
import org.xiyu.spartanshieldsunofficial.item.ShieldBaseItem;
import org.xiyu.spartanshieldsunofficial.util.PowerUnit;

public class FEPoweredShieldItem
extends ShieldBaseItem
implements IDamageShield,
IItemPoweredFE {
    protected int energyCapacity;
    protected int maxEnergyReceive;
    protected String modName;
    protected PowerUnit preferredEnergyUnit;

    public FEPoweredShieldItem(int capacity, int maxReceive, String modName, PowerUnit preferredUnit, boolean isTowerShieldIn, Item.Properties prop) {
        super(0, isTowerShieldIn, prop);
        this.energyCapacity = isTowerShieldIn ? Mth.floor((float)((float)capacity * 1.25f)) : capacity;
        this.maxEnergyReceive = maxReceive;
        this.modName = modName;
        this.preferredEnergyUnit = preferredUnit;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerPoweredShieldPropertyOverrides(this);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public int getBarWidth(ItemStack stack) {
        int energy = this.getStoredEnergy(stack);
        return Math.round(13.0f * (float)energy / (float)this.energyCapacity);
    }

    public boolean isBarVisible(ItemStack stack) {
        int energy = this.getStoredEnergy(stack);
        return energy < this.energyCapacity;
    }

    public int getBarColor(ItemStack stack) {
        return 6927359;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 6927359;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        LocalizedNumberFormatter formatter = NumberFormatter.withLocale((Locale)Minecraft.getInstance().getLanguageManager().getJavaLocale());
        tooltip.add((Component)Component.translatable((String)("tooltip.spartanshieldsunofficial." + this.preferredEnergyUnit.getCapacityTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.floor((float)((float)this.getFEStored(stack) * this.preferredEnergyUnit.getEnergyScaleToFE()))).toString(), formatter.format((long)Mth.floor((float)((float)this.getFECapacity(stack) * this.preferredEnergyUnit.getEnergyScaleToFE()))).toString()}));
        tooltip.add((Component)Component.translatable((String)("tooltip.spartanshieldsunofficial." + this.preferredEnergyUnit.getEnergyChargeRateTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.floor((float)((float)this.maxEnergyReceive * this.preferredEnergyUnit.getEnergyScaleToFE()))).toString()}));
        tooltip.add((Component)Component.translatable((String)("tooltip.spartanshieldsunofficial." + this.preferredEnergyUnit.getEnergyPerDamageTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.floor((float)((float)((Integer)Config.INSTANCE.damageToFEMultiplier.get() * 2) * this.preferredEnergyUnit.getEnergyScaleToFE()))).toString()}));
        tooltip.add((Component)Component.translatable((String)"tooltip.spartanshieldsunofficial.fe_shield.desc"));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        if (this.getFEStored(stack) > 0) {
            return UseAnim.BLOCK;
        }
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        ItemStack stack = player.getItemInHand(hand);
        if (this.getFEStored(stack) > 0) {
            return InteractionResultHolder.consume((Object)stack);
        }
        if (level.isClientSide) {
            player.sendSystemMessage((Component)Component.literal((String)(ChatFormatting.YELLOW.toString() + I18n.get((String)"message.spartanshieldsunofficial.powered_shield_block_fail", (Object[])new Object[]{stack.getHoverName().getString()}))));
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @Override
    public void damageShield(ItemStack shieldStack, Player player, Entity attacker, float damage) {
        int energyToUse = Mth.floor((float)damage);
        int currentEnergy = this.getStoredEnergy(shieldStack);
        int energyRemoved = Math.min(energyToUse, currentEnergy);
        this.setStoredEnergy(shieldStack, currentEnergy -= energyRemoved);
        if (currentEnergy == 0) {
            Level level = player.level();
            player.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + level.random.nextFloat() * 0.4f);
        }
    }

    public FEPoweredShieldItem setCapacity(int capacity) {
        this.energyCapacity = capacity;
        return this;
    }

    public FEPoweredShieldItem setMaxReceive(int maxReceive) {
        this.maxEnergyReceive = maxReceive;
        return this;
    }

    @Override
    public int receiveFE(ItemStack container, int maxReceive, boolean simulate) {
        int energy = this.getStoredEnergy(container);
        int energyReceived = Math.min(this.energyCapacity - energy, Math.min(this.maxEnergyReceive, maxReceive));
        if (!simulate) {
            this.setStoredEnergy(container, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractFE(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getFEStored(ItemStack container) {
        return (Integer)container.getOrDefault((DataComponentType)ModDataComponents.STORED_ENERGY.get(), (Object)0);
    }

    public int getStoredEnergy(ItemStack stack) {
        return this.getFEStored(stack);
    }

    public void setStoredEnergy(ItemStack stack, int energy) {
        stack.set((DataComponentType)ModDataComponents.STORED_ENERGY.get(), (Object)energy);
    }

    @Override
    public int getFECapacity(ItemStack container) {
        return this.energyCapacity;
    }

    @Override
    public boolean canExtractFE(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canReceiveFE(ItemStack stack) {
        return true;
    }
}

