/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.xiyu.spartanshieldsunofficial.client.render.item.TowerShieldBEWLR;
import org.xiyu.spartanshieldsunofficial.config.Config;
import org.xiyu.spartanshieldsunofficial.init.ModDataComponents;
import org.xiyu.spartanshieldsunofficial.init.ModEnchantments;
import org.xiyu.spartanshieldsunofficial.util.EnchantmentConstants;

public class ShieldBaseItem
extends ShieldItem {
    protected final boolean isTowerShield;
    protected int maxDurability;

    public ShieldBaseItem(int defaultDurability, boolean isTowerShieldIn, Item.Properties prop) {
        super(prop.durability(isTowerShieldIn ? Mth.floor((float)((float)defaultDurability * 1.25f)) : defaultDurability));
        this.maxDurability = defaultDurability;
        this.isTowerShield = isTowerShieldIn;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldBaseItem.this.isTowerShield ? TowerShieldBEWLR.INSTANCE : super.getCustomRenderer();
            }
        });
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDurability;
    }

    public void setMaxDamage(int maxDamage) {
        this.maxDurability = this.isTowerShield ? Mth.floor((double)((double)maxDamage * (Double)Config.INSTANCE.towerShieldDurabilityMultiplier.get())) : maxDamage;
    }

    public void appendHoverText(ItemStack stackIn, Item.TooltipContext context, List<Component> tooltipIn, TooltipFlag flagIn) {
        BannerPatternLayers patterns;
        if (this.isTowerShield && !stackIn.isEmpty() && (patterns = (BannerPatternLayers)stackIn.get(DataComponents.BANNER_PATTERNS)) != null && !patterns.layers().isEmpty()) {
            DyeColor dyeColor = (DyeColor)stackIn.get(DataComponents.BASE_COLOR);
            if (dyeColor == null) {
                dyeColor = DyeColor.WHITE;
            }
            tooltipIn.add((Component)Component.empty());
            tooltipIn.add((Component)Component.translatable((String)"tooltip.spartanshieldsunofficial.has_patterns"));
            tooltipIn.add((Component)Component.translatable((String)String.format("block.minecraft.%s_banner", dyeColor.name().toLowerCase())).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GRAY}));
            BannerItem.appendHoverTextFromBannerBlockEntityTag((ItemStack)stackIn, tooltipIn);
        }
        this.addEffectsTooltip(stackIn, context, tooltipIn, flagIn);
    }

    public String getDescriptionId(ItemStack stack) {
        return this.getOrCreateDescriptionId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addEffectsTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        int paybackLevel;
        Level level = context.level();
        if (level != null && (paybackLevel = EnchantmentConstants.getEnchantmentLevel(level, stack, ModEnchantments.PAYBACK)) != 0) {
            float paybackDamage = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.PAYBACK_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue();
            tooltip.add((Component)Component.translatable((String)"tooltip.spartanshieldsunofficial.payback_bonus", (Object[])new Object[]{ChatFormatting.GRAY.toString() + Float.toString(paybackDamage)}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

