/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.xiyu.spartanshieldsunofficial.init.ModRecipes;
import org.xiyu.spartanshieldsunofficial.item.FEPoweredShieldItem;

public class PoweredShieldUpgradeRecipe
implements CraftingRecipe {
    private final ShapedRecipe internalRecipe;

    public PoweredShieldUpgradeRecipe(ShapedRecipe baseRecipe) {
        this.internalRecipe = baseRecipe;
    }

    public ShapedRecipe getInternalRecipe() {
        return this.internalRecipe;
    }

    public boolean matches(CraftingInput inv, Level level) {
        return this.internalRecipe.matches(inv, level);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        FEPoweredShieldItem feItem;
        ItemStack resultStack = this.getResultItem(registries).copy();
        int feToTransfer = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof FEPoweredShieldItem)) continue;
            FEPoweredShieldItem feItem2 = (FEPoweredShieldItem)item;
            feToTransfer += feItem2.getStoredEnergy(stack);
        }
        int maxFE = 0;
        Item item = resultStack.getItem();
        if (item instanceof FEPoweredShieldItem) {
            feItem = (FEPoweredShieldItem)item;
            maxFE = feItem.getFECapacity(resultStack);
        }
        feToTransfer = Mth.clamp((int)feToTransfer, (int)0, (int)maxFE);
        item = resultStack.getItem();
        if (item instanceof FEPoweredShieldItem) {
            feItem = (FEPoweredShieldItem)item;
            feItem.setStoredEnergy(resultStack, feToTransfer);
        }
        return resultStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.internalRecipe.canCraftInDimensions(width, height);
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.internalRecipe.getResultItem(registries);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.POWERED_SHIELD_UPGRADE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        return this.internalRecipe.getRemainingItems((RecipeInput)inv);
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.internalRecipe.getIngredients();
    }

    public boolean isSpecial() {
        return this.internalRecipe.isSpecial();
    }

    public String getGroup() {
        return this.internalRecipe.getGroup();
    }

    public ItemStack getToastSymbol() {
        return this.internalRecipe.getToastSymbol();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<PoweredShieldUpgradeRecipe> {
        public static final MapCodec<PoweredShieldUpgradeRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(PoweredShieldUpgradeRecipe::new, PoweredShieldUpgradeRecipe::getInternalRecipe);
        public static final StreamCodec<RegistryFriendlyByteBuf, PoweredShieldUpgradeRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(PoweredShieldUpgradeRecipe::new, PoweredShieldUpgradeRecipe::getInternalRecipe);

        public MapCodec<PoweredShieldUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PoweredShieldUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

