/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.xiyu.spartanshieldsunofficial.init.ModRecipes;

public class ShieldBannerRecipe
extends ShieldDecorationRecipe {
    protected final Item shieldItem;

    public ShieldBannerRecipe(CraftingBookCategory category, Item shield) {
        super(category);
        this.shieldItem = shield;
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack2 = inv.getItem(i);
            if (itemstack2.isEmpty()) continue;
            if (itemstack2.is(ItemTags.BANNERS)) {
                if (!itemstack1.isEmpty()) {
                    return false;
                }
                itemstack1 = itemstack2;
                continue;
            }
            if (itemstack2.getItem() != this.shieldItem) {
                return false;
            }
            if (!itemstack.isEmpty()) {
                return false;
            }
            if (itemstack2.has(DataComponents.BANNER_PATTERNS)) {
                return false;
            }
            itemstack = itemstack2;
        }
        return !itemstack.isEmpty() && !itemstack1.isEmpty();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack bannerStack = ItemStack.EMPTY;
        ItemStack shieldStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack2 = inv.getItem(i);
            if (itemstack2.isEmpty()) continue;
            if (itemstack2.is(ItemTags.BANNERS)) {
                bannerStack = itemstack2;
                continue;
            }
            if (itemstack2.getItem() != this.shieldItem) continue;
            shieldStack = itemstack2.copy();
        }
        if (shieldStack.isEmpty()) {
            return shieldStack;
        }
        BannerPatternLayers patterns = (BannerPatternLayers)bannerStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        shieldStack.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
        shieldStack.set(DataComponents.BASE_COLOR, (Object)((BannerItem)bannerStack.getItem()).getColor());
        return shieldStack;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (!itemstack.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SHIELD_BANNER.get();
    }

    public Item getShieldItem() {
        return this.shieldItem;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<ShieldBannerRecipe> {
        public static final MapCodec<ShieldBannerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.EQUIPMENT).forGetter(ShieldBannerRecipe::category), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("shield").forGetter(ShieldBannerRecipe::getShieldItem)).apply((Applicative)instance, ShieldBannerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShieldBannerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, ShieldBannerRecipe::category, (StreamCodec)ByteBufCodecs.fromCodec((Codec)BuiltInRegistries.ITEM.byNameCodec()), ShieldBannerRecipe::getShieldItem, ShieldBannerRecipe::new);

        public MapCodec<ShieldBannerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShieldBannerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

