/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.spartanshieldsunofficial.config.Config;
import org.xiyu.spartanshieldsunofficial.init.ModDataComponents;
import org.xiyu.spartanshieldsunofficial.init.ModEnchantments;
import org.xiyu.spartanshieldsunofficial.init.ModSounds;
import org.xiyu.spartanshieldsunofficial.init.ModStats;
import org.xiyu.spartanshieldsunofficial.tags.ModItemTags;

public record ShieldBashPacket(InteractionHand hand, int entityId, boolean attackEntity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShieldBashPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spartanshieldsunofficial", (String)"shield_bash"));
    public static final StreamCodec<ByteBuf, ShieldBashPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL.map(b -> b != false ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, h -> h == InteractionHand.MAIN_HAND), ShieldBashPacket::hand, (StreamCodec)ByteBufCodecs.INT, ShieldBashPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, ShieldBashPacket::attackEntity, ShieldBashPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ShieldBashPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            Entity victim = player.level().getEntity(packet.entityId());
            if (player.isBlocking()) {
                ItemStack shieldStack = player.getItemInHand(packet.hand());
                boolean isTowerShield = shieldStack.is(ModItemTags.TOWER_SHIELDS);
                if (!shieldStack.isEmpty() && !player.getCooldowns().isOnCooldown(shieldStack.getItem()) && player.getUseItem().is(ModItemTags.SHIELDS_WITH_BASH) && player.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
                    if (packet.attackEntity() && victim != null && victim instanceof LivingEntity) {
                        int knockLvl = ShieldBashPacket.getEnchantmentLevel((Player)player, shieldStack, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK);
                        if (isTowerShield) {
                            double reach = player.entityInteractionRange();
                            for (LivingEntity entity : player.level().getEntitiesOfClass(LivingEntity.class, victim.getBoundingBox().inflate(1.0, 0.25, 1.0), target -> target != player && target != victim && !target.isAlliedTo((Entity)player) && (!(target instanceof ArmorStand) || !((ArmorStand)target).isMarker()) && player.distanceToSqr((Entity)target) < reach * reach)) {
                                ShieldBashPacket.bashEntity((Entity)entity, (Player)player, shieldStack, knockLvl, packet.hand());
                            }
                        }
                        boolean powerfulBash = ShieldBashPacket.bashEntity(victim, (Player)player, shieldStack, knockLvl, packet.hand());
                        player.level().playSound((Player)null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.SHIELD_BASH_HIT.get(), player.getSoundSource(), 1.0f, powerfulBash ? 2.0f : 1.0f);
                        player.crit(victim);
                        player.awardStat(ModStats.SHIELD_BASH_HITS.get());
                    } else {
                        player.level().playSound((Player)null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.SHIELD_BASH_MISS.get(), player.getSoundSource(), 0.5f, 0.01f);
                    }
                    player.stopUsingItem();
                    player.getCooldowns().addCooldown(shieldStack.getItem(), (isTowerShield ? (Integer)Config.INSTANCE.cooldownTowerShieldBash.get() : (Integer)Config.INSTANCE.cooldownShieldBash.get()).intValue());
                }
            }
        });
    }

    private static int getEnchantmentLevel(Player player, ItemStack stack, ResourceKey<Enchantment> key) {
        Holder.Reference holder = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)stack);
    }

    protected static boolean bashEntity(Entity targetEntity, Player player, ItemStack shieldStack, int knockbackLevel, InteractionHand hand) {
        targetEntity.invulnerableTime = 0;
        ((LivingEntity)targetEntity).knockback((double)(1.0f + (float)knockbackLevel), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
        float bashDamage = 1.0f;
        int paybackLevel = ShieldBashPacket.getEnchantmentLevel(player, shieldStack, ModEnchantments.PAYBACK);
        if (paybackLevel > 0) {
            bashDamage += ((Float)shieldStack.getOrDefault((DataComponentType)ModDataComponents.PAYBACK_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue();
            shieldStack.set((DataComponentType)ModDataComponents.PAYBACK_DAMAGE.get(), (Object)Float.valueOf(0.0f));
        }
        targetEntity.hurt(player.damageSources().playerAttack(player), bashDamage);
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        shieldStack.hurtAndBreak(5, (LivingEntity)player, slot);
        int firebrandLvl = ShieldBashPacket.getEnchantmentLevel(player, shieldStack, ModEnchantments.FIREBRAND);
        if (firebrandLvl > 0) {
            targetEntity.setRemainingFireTicks(firebrandLvl * 5 * 20);
        }
        return bashDamage > 1.0f;
    }
}

