/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.util;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class EnchantmentConstants {
    public static final String NBT_PAYBACK_DMG = "PaybackDamage";

    public static float getPaybackMaxDamageCapacity(int level) {
        return 2.0f * (float)level;
    }

    public static float getPaybackAbsorbedDamageRatio() {
        return 0.5f;
    }

    public static int getEnchantmentLevel(Level level, ItemStack stack, ResourceKey<Enchantment> enchantmentKey) {
        if (level == null || stack.isEmpty()) {
            return 0;
        }
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Optional enchantmentOpt = registry.get(enchantmentKey);
        if (enchantmentOpt.isPresent()) {
            return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchantmentOpt.get()), (ItemStack)stack);
        }
        return 0;
    }
}

