/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class ChemiGeometry {
    private static final double offset = 0.005;
    private final Space s1;
    private final Space s2;

    private ChemiGeometry(Space s1, Space s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    private ChemiGeometry(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.s1 = new Space(x1, y1, z1);
        this.s2 = new Space(x2, y2, z2);
    }

    private ChemiGeometry(double x1, double y1, double z1) {
        this.s1 = new Space(x1, y1, z1);
        this.s2 = null;
    }

    public static ChemiGeometry create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ChemiGeometry(x1, y1, z1, x2, y2, z2);
    }

    public static ChemiGeometry create(double x1, double y1, double z1) {
        return new ChemiGeometry(x1, y1, z1);
    }

    public static ChemiGeometry createPix(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ChemiGeometry(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }

    public static ChemiGeometry createPixOffset(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ChemiGeometry(x1 / 16.0 + 0.005, y1 / 16.0 + 0.005, z1 / 16.0 + 0.005, x2 / 16.0 - 0.005, y2 / 16.0 - 0.005, z2 / 16.0 - 0.005);
    }

    public ChemiGeometry rotate(Direction dir) {
        Space rs1 = this.rotatesp(this.s1, dir);
        Space rs2 = this.rotatesp(this.s2, dir);
        return new ChemiGeometry(rs1, rs2);
    }

    public ChemiGeometry flush() {
        if (this.s2 == null) {
            throw new IllegalStateException("Not cubic object!");
        }
        double x1 = this.s1.x < this.s2.x ? this.s1.x : this.s2.x;
        double x2 = this.s1.x > this.s2.x ? this.s1.x : this.s2.x;
        double y1 = this.s1.y < this.s2.y ? this.s1.y : this.s2.y;
        double y2 = this.s1.y > this.s2.y ? this.s1.y : this.s2.y;
        double z1 = this.s1.z < this.s2.z ? this.s1.z : this.s2.z;
        double z2 = this.s1.z > this.s2.z ? this.s1.z : this.s2.z;
        return new ChemiGeometry(x1, y1, z1, x2, y2, z2);
    }

    public Space getLeastPole() {
        return this.s1;
    }

    public Space getMostPole() {
        if (this.s2 == null) {
            throw new IllegalStateException("Not cubic object!");
        }
        return this.s2;
    }

    public AABB toAABB() {
        if (this.s2 == null) {
            throw new IllegalStateException("Not cubic object!");
        }
        return new AABB(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
    }

    private Space rotatesp(@Nullable Space space, Direction dir) {
        if (space == null) {
            return null;
        }
        if (dir == Direction.NORTH) {
            return new Space(space.x, space.y, space.z);
        }
        if (dir == Direction.SOUTH) {
            return new Space(1.0 - space.x, space.y, 1.0 - space.z);
        }
        if (dir == Direction.EAST) {
            return new Space(1.0 - space.z, space.y, space.x);
        }
        if (dir == Direction.WEST) {
            return new Space(space.z, space.y, 1.0 - space.x);
        }
        if (dir == Direction.UP) {
            return new Space(space.x, 1.0 - space.z, space.y);
        }
        if (dir == Direction.DOWN) {
            return new Space(space.x, space.z, 1.0 - space.y);
        }
        throw new IllegalArgumentException("Unknown Direction " + dir.toString());
    }

    public record Space(double x, double y, double z) {
        public float fx() {
            return (float)this.x;
        }

        public float fy() {
            return (float)this.y;
        }

        public float fz() {
            return (float)this.z;
        }
    }
}

