/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BuddingCrystalBlock
extends Block {
    private final Supplier<Block> bud;
    private final Supplier<Block> crystal;

    public BuddingCrystalBlock(BlockBehaviour.Properties p, Supplier<Block> bud, Supplier<Block> crystal) {
        super(p);
        this.bud = bud;
        this.crystal = crystal;
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        ArrayList<Direction> crystalable = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            BlockState nbs = level.m_8055_(pos.m_121945_(dir));
            if (!nbs.m_60795_() && !nbs.m_60713_(this.bud.get())) continue;
            crystalable.add(dir);
        }
        if (!crystalable.isEmpty()) {
            int count = crystalable.size();
            if (random.m_188503_(20) < 10 - count) {
                Direction growing = (Direction)crystalable.get(random.m_188503_(crystalable.size()));
                BlockPos growpos = pos.m_121945_(growing);
                BlockState current = level.m_8055_(growpos);
                if (current.m_60795_()) {
                    BlockState budstate = this.getCrystal(this.bud.get(), growing);
                    level.m_46597_(growpos, budstate);
                } else {
                    BlockState crystalState = this.getCrystal(this.crystal.get(), growing);
                    level.m_46597_(growpos, crystalState);
                }
            }
        }
    }

    private BlockState getCrystal(Block block, Direction dir) {
        BlockState crystal = block.m_49966_();
        if (crystal.m_61138_((Property)BlockStateProperties.f_61372_)) {
            // empty if block
        }
        BlockState rotated = (BlockState)crystal.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
        return rotated;
    }
}

