/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import kandango.reagenica.block.ShapeStream;
import kandango.reagenica.block.entity.electrical.ElectricAbstract;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CableAbstract
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> FACING_MAP = Map.of(Direction.NORTH, NORTH, Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN);
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new HashMap<Integer, VoxelShape>();
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public CableAbstract(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = pos.m_121945_(dir);
            boolean connectable = this.shouldConnectTo(level, neighbor);
            state = (BlockState)state.m_61124_((Property)FACING_MAP.get(dir), (Comparable)Boolean.valueOf(connectable));
        }
        return state;
    }

    private boolean shouldConnectTo(Level lv, BlockPos pos) {
        return lv.m_7702_(pos) instanceof ElectricAbstract;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public boolean m_222958_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return false;
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos) {
        if (!level.m_5776_() && level instanceof Level) {
            Level lv = (Level)level;
            boolean connected = this.shouldConnectTo(lv, neighborPos);
            return (BlockState)state.m_61124_((Property)FACING_MAP.get(direction), (Comparable)Boolean.valueOf(connected));
        }
        return state;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        int key = this.getConnectionKey(state);
        return SHAPE_CACHE.computeIfAbsent(key, k -> this.buildShapefromState(state));
    }

    private int getConnectionKey(BlockState state) {
        int key = 0;
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            key |= 1;
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            key |= 2;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            key |= 4;
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            key |= 8;
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            key |= 0x10;
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            key |= 0x20;
        }
        return key;
    }

    private VoxelShape buildShapefromState(BlockState state) {
        return ShapeStream.of(CORE_SHAPE).addif((Boolean)state.m_61143_((Property)UP), CableAbstract.makeConnectionShape(Direction.UP)).addif((Boolean)state.m_61143_((Property)DOWN), CableAbstract.makeConnectionShape(Direction.DOWN)).addif((Boolean)state.m_61143_((Property)NORTH), CableAbstract.makeConnectionShape(Direction.NORTH)).addif((Boolean)state.m_61143_((Property)SOUTH), CableAbstract.makeConnectionShape(Direction.SOUTH)).addif((Boolean)state.m_61143_((Property)WEST), CableAbstract.makeConnectionShape(Direction.WEST)).addif((Boolean)state.m_61143_((Property)EAST), CableAbstract.makeConnectionShape(Direction.EAST)).build();
    }

    private static VoxelShape makeConnectionShape(Direction direction) {
        switch (direction) {
            case UP: {
                return CableAbstract.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
            }
            case DOWN: {
                return CableAbstract.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
            }
            case NORTH: {
                return CableAbstract.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
            }
            case SOUTH: {
                return CableAbstract.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
            }
            case WEST: {
                return CableAbstract.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
            }
            case EAST: {
                return CableAbstract.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
            }
        }
        return Shapes.m_83040_();
    }
}

