/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block;

import java.util.Map;
import javax.annotation.Nonnull;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.ShapeStream;
import kandango.reagenica.block.entity.CookingPotBlockEntity;
import kandango.reagenica.block.entity.util.DestroyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CookingPot
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = ShapeStream.create(1.0, 0.0, 1.0, 15.0, 2.0, 15.0).add(3.0, 2.0, 3.0, 13.0, 11.0, 13.0).add(1.0, 9.0, 6.0, 3.0, 10.0, 10.0).add(13.0, 9.0, 6.0, 15.0, 10.0, 10.0).createRots(Direction.values());

    public CookingPot() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(2.0f).m_60924_((state, world, pos) -> false));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public CookingPotBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CookingPotBlockEntity(pos, state);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return BlockUtil.getTicker(level, state, type);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!state.m_60713_(newState.m_60734_()) && (be = level.m_7702_(pos)) instanceof CookingPotBlockEntity) {
            CookingPotBlockEntity cooker = (CookingPotBlockEntity)be;
            DestroyHelper.dropItems((IItemHandler)cooker.getItemHandler(), level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPES.get(facing);
    }
}

