/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import kandango.reagenica.block.ShapeStream;
import kandango.reagenica.block.entity.electrical.PipeAbstractBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public abstract class PipeAbstract
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> FACING_MAP = Map.of(Direction.NORTH, NORTH, Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN);
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new HashMap<Integer, VoxelShape>();
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public PipeAbstract(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            boolean connectable = this.shouldConnectTo(level, pos, dir);
            state = (BlockState)state.m_61124_((Property)FACING_MAP.get(dir), (Comparable)Boolean.valueOf(connectable));
        }
        return state;
    }

    private boolean shouldConnectTo(Level lv, BlockPos pos, Direction dir) {
        BlockPos relative = pos.m_121945_(dir);
        BlockEntity be = lv.m_7702_(relative);
        BlockState thisState = lv.m_8055_(pos);
        BlockState neighborState = lv.m_8055_(relative);
        if (be != null) {
            if (be instanceof PipeAbstractBlockEntity) {
                boolean samePipeType = neighborState.m_60734_() == thisState.m_60734_();
                boolean isOpenSide = be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).isPresent();
                return samePipeType && isOpenSide;
            }
            return be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).isPresent();
        }
        return false;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public boolean m_222958_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return false;
    }

    public FluidState m_5888_(@Nonnull BlockState state) {
        return Fluids.f_76191_.m_76145_();
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos) {
        if (!level.m_5776_() && level instanceof Level) {
            Level lv = (Level)level;
            boolean connected = this.shouldConnectTo(lv, pos, direction);
            return (BlockState)state.m_61124_((Property)FACING_MAP.get(direction), (Comparable)Boolean.valueOf(connected));
        }
        return state;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        int key = this.getConnectionKey(state);
        return SHAPE_CACHE.computeIfAbsent(key, k -> this.buildShapefromState(state));
    }

    private int getConnectionKey(BlockState state) {
        int key = 0;
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            key |= 1;
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            key |= 2;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            key |= 4;
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            key |= 8;
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            key |= 0x10;
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            key |= 0x20;
        }
        return key;
    }

    private VoxelShape buildShapefromState(BlockState state) {
        return ShapeStream.of(CORE_SHAPE).addif((Boolean)state.m_61143_((Property)UP), PipeAbstract.makeConnectionShape(Direction.UP)).addif((Boolean)state.m_61143_((Property)DOWN), PipeAbstract.makeConnectionShape(Direction.DOWN)).addif((Boolean)state.m_61143_((Property)NORTH), PipeAbstract.makeConnectionShape(Direction.NORTH)).addif((Boolean)state.m_61143_((Property)SOUTH), PipeAbstract.makeConnectionShape(Direction.SOUTH)).addif((Boolean)state.m_61143_((Property)WEST), PipeAbstract.makeConnectionShape(Direction.WEST)).addif((Boolean)state.m_61143_((Property)EAST), PipeAbstract.makeConnectionShape(Direction.EAST)).build();
    }

    private static VoxelShape makeConnectionShape(Direction direction) {
        switch (direction) {
            case UP: {
                return PipeAbstract.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
            }
            case DOWN: {
                return PipeAbstract.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
            }
            case NORTH: {
                return PipeAbstract.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
            }
            case SOUTH: {
                return PipeAbstract.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
            }
            case WEST: {
                return PipeAbstract.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
            }
            case EAST: {
                return PipeAbstract.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
            }
        }
        return Shapes.m_83040_();
    }
}

