/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block;

import java.util.HashMap;
import java.util.Map;
import kandango.reagenica.ChemiGeometry;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeStream {
    private final VoxelShape shape;

    private ShapeStream(VoxelShape vox) {
        this.shape = vox;
    }

    public static ShapeStream createEmpty() {
        return new ShapeStream(Shapes.m_83040_());
    }

    public static ShapeStream of(VoxelShape vox) {
        return new ShapeStream(vox);
    }

    public static ShapeStream create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ShapeStream(Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public ShapeStream add(VoxelShape vox) {
        return new ShapeStream(Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)vox));
    }

    public ShapeStream add(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ShapeStream(Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2)));
    }

    public ShapeStream addif(boolean condition, VoxelShape vox) {
        if (condition) {
            return new ShapeStream(Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)vox));
        }
        return this;
    }

    public ShapeStream addif(boolean condition, double x1, double y1, double z1, double x2, double y2, double z2) {
        if (condition) {
            return new ShapeStream(Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2)));
        }
        return this;
    }

    public VoxelShape build() {
        return this.shape.m_83296_();
    }

    public ShapeStream rotate(Direction dir) {
        ShapeStream buf = ShapeStream.createEmpty();
        for (AABB box : this.shape.m_83299_()) {
            AABB rotated = ChemiGeometry.create(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_).rotate(dir).flush().toAABB();
            buf = buf.add(Shapes.m_83064_((AABB)rotated));
        }
        return buf;
    }

    public Map<Direction, VoxelShape> createRots(Direction[] dirs) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        for (Direction dir : dirs) {
            map.put(dir, this.rotate(dir).build());
        }
        return map;
    }

    public Map<Direction, VoxelShape> createRots(Iterable<Direction> dirs) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        for (Direction dir : dirs) {
            map.put(dir, this.rotate(dir).build());
        }
        return map;
    }
}

