/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.recipes.AnalyzerRecipe;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.items.ItemStackWithChance;
import kandango.reagenica.screen.AnalyzerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AnalyzerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final Random rand = new Random();
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            AnalyzerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return slot == 0;
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).outputslot(1, 2, 3, 4, 5, 6, 7).build());

    public AnalyzerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ANALYZER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new AnalyzerMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.analyzer");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void analyze() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        ItemStack item = this.itemHandler.getStackInSlot(0);
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, item);
        Optional mayrecipe = lv.m_7465_().m_44015_((RecipeType)ModRecipes.ANALYZER_TYPE.get(), (Container)container, lv);
        if (mayrecipe.isPresent()) {
            AnalyzerRecipe recipe = (AnalyzerRecipe)mayrecipe.orElseThrow();
            ItemStack returnitem = recipe.getReturnItem();
            List<ItemStackWithChance> results = recipe.getResults();
            this.itemHandler.getStackInSlot(0).m_41774_(1);
            boolean flag = ItemStackUtil.addStackToSlotifPossible(this.itemHandler, 1, returnitem);
            if (!flag) {
                this.drop(lv, returnitem);
            }
            for (ItemStackWithChance stack : results) {
                this.insert(lv, stack.roll(this.rand));
            }
        }
    }

    private void insert(@Nonnull Level lv, ItemStack stack) {
        for (int i = 2; i <= 7; ++i) {
            boolean insert = ItemStackUtil.addStackToSlotifPossible(this.itemHandler, i, stack);
            if (!insert) continue;
            return;
        }
        this.drop(lv, stack);
    }

    private void drop(@Nonnull Level lv, ItemStack item) {
        if (lv.f_46443_) {
            return;
        }
        if (!item.m_41619_()) {
            double x = (double)this.m_58899_().m_123341_() + 0.5;
            double y = (double)this.m_58899_().m_123342_() + 1.1;
            double z = (double)this.m_58899_().m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(lv, x, y, z, item);
            lv.m_7967_((Entity)itemEntity);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }
}

