/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.IBlockEntityWithSlider;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.recipes.BlastFurnaceRecipe;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.screen.BlastFurnaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BlastFurnaceBlockEntity
extends BlockEntity
implements MenuProvider,
IBlockEntityWithSlider,
ITickableBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            BlastFurnaceBlockEntity.this.m_6596_();
            BlastFurnaceBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot == 0) {
                return true;
            }
            if (slot == 1) {
                return stack.m_150930_(Items.f_42413_) || stack.m_150930_(Items.f_42414_);
            }
            return false;
        }
    };
    private boolean dirty = true;
    private int temperature = 200;
    private Optional<BlastFurnaceRecipe> cachedRecipe = Optional.empty();
    private int progress = 0;
    private int fuel = 0;
    private int fuelmax = 1600;
    private int maxtemp = 16000;
    private float expSum = 0.0f;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).fuelslot(1).outputslot(2, 3).build());

    public void setTemp(int t) {
        this.temperature = t;
    }

    public int getTemp() {
        return this.temperature;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int p) {
        this.fuel = p;
    }

    public int getFuelMax() {
        return this.fuelmax;
    }

    public void setFuelMax(int p) {
        this.fuelmax = p;
    }

    public int getmaxTemp() {
        return this.maxtemp;
    }

    public void setmaxTemp(int p) {
        this.maxtemp = p;
    }

    public BlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLAST_FURNACE.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.fuel = tag.m_128451_("Fuel");
        this.fuelmax = tag.m_128451_("MaxFuel");
        this.progress = tag.m_128451_("Progress");
        this.temperature = tag.m_128451_("Temperature");
        this.maxtemp = tag.m_128451_("MaxTemp");
        this.expSum = tag.m_128457_("Exp");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
        tag.m_128405_("Fuel", this.fuel);
        tag.m_128405_("MaxFuel", this.fuelmax);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("Temperature", this.temperature);
        tag.m_128405_("MaxTemp", this.maxtemp);
        tag.m_128350_("Exp", this.expSum);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new BlastFurnaceMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.blast_furnace");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            SimpleContainer container = new SimpleContainer(5);
            container.m_6836_(0, this.itemHandler.getStackInSlot(0));
            this.cachedRecipe = lv.m_7465_().m_44015_((RecipeType)ModRecipes.BLAST_FURNACE_TYPE.get(), (Container)container, lv);
            if (this.fuel == 0) {
                ItemStack fuelstack = this.itemHandler.getStackInSlot(1);
                if (fuelstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("minecraft", "coals")))) {
                    this.fuelmax = this.fuel = ForgeHooks.getBurnTime((ItemStack)fuelstack, (RecipeType)RecipeType.f_44108_);
                    this.itemHandler.getStackInSlot(1).m_41774_(1);
                    LitUtil.setLit(true, lv, this.f_58858_);
                } else {
                    LitUtil.setLit(false, lv, this.f_58858_);
                }
            }
            this.dirty = false;
        }
        if (this.fuel >= 1) {
            --this.fuel;
            this.temperature = this.heatup(this.temperature);
            if (this.fuel == 0) {
                this.dirty = true;
            }
        } else {
            this.temperature = this.cooldown(this.temperature);
        }
        if (this.cachedRecipe.isPresent()) {
            BlastFurnaceRecipe recipe = this.cachedRecipe.orElseThrow();
            int minTemp = recipe.getMinTemp();
            int maxTemp = recipe.getMaxTemp();
            if (minTemp <= this.temperature && this.temperature <= maxTemp) {
                ItemStack byproduct;
                int speed = (this.temperature - minTemp) * 6000 / (maxTemp - minTemp) + 4000;
                ItemStack output = recipe.getOutput();
                if (this.canInsert(output, byproduct = recipe.getByproduct())) {
                    this.progress += speed;
                    if (this.progress >= 2000000) {
                        this.progress = 0;
                        this.itemHandler.setStackInSlot(2, ItemStackUtil.addStack(this.itemHandler.getStackInSlot(2).m_41777_(), output.m_41777_()));
                        this.itemHandler.setStackInSlot(3, ItemStackUtil.addStack(this.itemHandler.getStackInSlot(3).m_41777_(), byproduct.m_41777_()));
                        this.itemHandler.extractItem(0, 1, false);
                        this.expSum += recipe.getExp();
                    }
                }
            }
        }
    }

    private int heatup(int current) {
        int tm = 0;
        tm = current < 6000 ? current + 10 : (current < 10000 ? current + 5 : (current < 12000 ? current + 2 : (current < 16000 ? current + 1 : 16000)));
        if (tm > this.maxtemp) {
            return Math.max(current - 5, this.maxtemp);
        }
        return tm;
    }

    private int cooldown(int current) {
        return Math.max(current - 1, 200);
    }

    private boolean canInsert(ItemStack main, ItemStack sub) {
        ItemStack resultslot = this.itemHandler.getStackInSlot(2);
        ItemStack byproductslot = this.itemHandler.getStackInSlot(3);
        return !(!resultslot.m_41619_() && !ItemStackUtil.canAddStack(resultslot, main) || !byproductslot.m_41619_() && !ItemStackUtil.canAddStack(byproductslot, sub));
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void setSliderValue(double value) {
        this.maxtemp = (int)(value * 16000.0);
        this.m_6596_();
    }

    @Override
    public double getSliderValue() {
        return (double)this.maxtemp / 16000.0;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    public void awardExp(@Nonnull Player player) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            int award = (int)this.expSum;
            ExperienceOrb.m_147082_((ServerLevel)slv, (Vec3)player.m_20182_(), (int)award);
            this.expSum -= (float)award;
        }
    }
}

