/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.item.bioreagent.BioReagent;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.recipes.FermentationRecipe;
import kandango.reagenica.screen.ChemicalFermenterMenu;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class ChemicalFermenterBlockEntity
extends BlockEntity
implements MenuProvider,
IDualTankBlock,
ITickableBlockEntity {
    public static final int FERMENT_TIME = 30000;
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            ChemicalFermenterBlockEntity.this.m_6596_();
            ChemicalFermenterBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot < 4) {
                return true;
            }
            if (slot == 4) {
                return stack.m_41720_() instanceof BioReagent;
            }
            if (slot == 5) {
                return false;
            }
            if (slot == 6) {
                return true;
            }
            if (slot == 7) {
                return false;
            }
            if (slot == 8) {
                return true;
            }
            if (slot == 9) {
                return false;
            }
            return false;
        }
    };
    private final FluidTank outputTank = new FluidTank(4000){

        protected void onContentsChanged() {
            ChemicalFermenterBlockEntity.this.m_6596_();
            ChemicalFermenterBlockEntity.this.dirty = true;
            ChemicalFermenterBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank inputTank = new FluidTank(4000){

        protected void onContentsChanged() {
            ChemicalFermenterBlockEntity.this.m_6596_();
            ChemicalFermenterBlockEntity.this.dirty = true;
            ChemicalFermenterBlockEntity.this.syncFluidToClient();
        }
    };
    private int processprogress = 0;
    private boolean dirty = true;
    private FermentationRecipe cachedRecipe = null;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).customInputRule(SlotPriorityRule.single(stack -> stack.m_41720_() instanceof BioReagent, 4)).anyfluidInputslot(6).anyfluidOutputslot(8).outputslot(5).build());
    private final LazyOptional<IFluidHandler> fluidTankLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.inputTank, this.outputTank));

    public ChemicalFermenterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHEMICAL_FERMENTER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.outputTank.readFromNBT(tag.m_128469_("Tank"));
        this.inputTank.readFromNBT(tag.m_128469_("InputTank"));
        this.processprogress = tag.m_128451_("Progress");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.outputTank.writeToNBT(fluidTag);
        tag.m_128365_("Tank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.inputTank.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        tag.m_128405_("Progress", this.processprogress);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidTankLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTank() {
        return this.outputTank;
    }

    public FluidTank getInputFluidTank() {
        return this.inputTank;
    }

    public int getprogress() {
        return this.processprogress;
    }

    public void setProgress(int v) {
        this.processprogress = v;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ChemicalFermenterMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.fermenter");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.inputTank.getFluid().copy(), this.outputTank.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            boolean out;
            SimpleContainer container = new SimpleContainer(5);
            container.m_6836_(0, this.itemHandler.getStackInSlot(0));
            container.m_6836_(1, this.itemHandler.getStackInSlot(1));
            container.m_6836_(2, this.itemHandler.getStackInSlot(2));
            container.m_6836_(3, this.itemHandler.getStackInSlot(3));
            container.m_6836_(4, this.itemHandler.getStackInSlot(4));
            this.cachedRecipe = FermentationRecipe.getRecipe((Container)container, this.inputTank.getFluid(), lv).filter(r -> this.canOutput((FermentationRecipe)r)).orElse(null);
            if (!this.itemHandler.getStackInSlot(6).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 6, 7, this.inputTank);
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 6, 7, this.inputTank);
                dirtyflag |= in | out;
            }
            if (!this.itemHandler.getStackInSlot(8).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 8, 9, this.outputTank);
                dirtyflag |= out;
            }
        }
        this.dirty = dirtyflag;
        if (this.cachedRecipe != null) {
            FluidStack output = this.cachedRecipe.getResultFluid();
            ItemStack outitem = this.cachedRecipe.getOutputItem();
            ItemStack bioreagent = this.itemHandler.getStackInSlot(4);
            int speed = 30;
            Item item = bioreagent.m_41720_();
            if (item instanceof BioReagent) {
                BioReagent br = (BioReagent)item;
                speed += br.getSpeed(bioreagent);
            }
            this.processprogress += speed;
            if (this.processprogress >= 30000) {
                this.inputTank.drain(this.cachedRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.outputTank.fill(output, IFluidHandler.FluidAction.EXECUTE);
                ItemStackUtil.addStackToSlot(this.itemHandler, 5, outitem);
                this.consumeIngredient(this.cachedRecipe.getInputs(), lv);
                this.consumeBioseed(this.cachedRecipe);
                this.processprogress = 0;
                lv.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                this.dirty = true;
            }
        } else {
            this.processprogress = 0;
        }
    }

    private void consumeIngredient(List<Ingredient> ingredients, @Nonnull Level lv) {
        block0: for (Ingredient ingredient : ingredients) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (!ingredient.test(stack)) continue;
                if (stack.hasCraftingRemainingItem()) {
                    ItemStack remaining = stack.getCraftingRemainingItem();
                    ItemStackUtil.insertOrElseThrow(lv, this.f_58858_, this.itemHandler, remaining, 0, 4);
                }
                this.itemHandler.extractItem(i, 1, false);
                continue block0;
            }
        }
    }

    private void consumeBioseed(FermentationRecipe recipe) {
        Ingredient bioseed = recipe.getBioseed();
        if (!bioseed.m_43947_()) {
            ItemStack consumed = ItemStackUtil.getDamagedItem(this.itemHandler.getStackInSlot(4), 1, () -> ItemStack.f_41583_);
            this.itemHandler.setStackInSlot(4, consumed);
        }
    }

    private boolean canOutput(FermentationRecipe recipe) {
        FluidStack output = recipe.getResultFluid();
        ItemStack outitem = recipe.getOutputItem();
        return FluidStackUtil.canFullyInsertToTank(output, this.outputTank) && ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(5), outitem);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.inputTank.setFluid(fluid1);
        this.outputTank.setFluid(fluid2);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidTankLazyOptional.invalidate();
    }
}

