/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.item.reagent.LiquidKitchen;
import kandango.reagenica.recipes.CookingRecipe;
import kandango.reagenica.screen.CookingPotMenu;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CookingPotBlockEntity
extends BlockEntity
implements MenuProvider,
ITickableBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            CookingPotBlockEntity.this.m_6596_();
            CookingPotBlockEntity.this.changed = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot == 7) {
                return stack.m_150930_(Items.f_42399_);
            }
            if (slot == 8) {
                return false;
            }
            return slot != 9;
        }
    };
    private int progress = 0;
    private int fuel = 0;
    private int maxfuel = 0;
    private boolean changed = true;
    private CookingRecipe recipecache;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).customInputRule(SlotPriorityRule.single(stack -> stack.m_150930_(Items.f_42399_), 7)).fuelslot(6).outputslot(8, 9).build());

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int p) {
        this.fuel = p;
    }

    public int getMaxFuel() {
        return this.maxfuel;
    }

    public void setMaxFuel(int p) {
        this.maxfuel = p;
    }

    public CookingPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COOKING_POT.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.progress = tag.m_128451_("Progress");
        this.fuel = tag.m_128451_("Fuel");
        this.maxfuel = tag.m_128451_("MaxFuel");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("Fuel", this.fuel);
        tag.m_128405_("MaxFuel", this.maxfuel);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new CookingPotMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.cooking_pot");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        ItemStack fuelslot;
        int burn;
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.changed) {
            SimpleContainer container = new SimpleContainer(6);
            for (int i = 0; i < 6; ++i) {
                container.m_6836_(i, this.itemHandler.getStackInSlot(i));
            }
            this.recipecache = CookingRecipe.getRecipe((Container)container, lv).orElse(null);
            if (this.recipecache != null && !this.recipeInsertable(this.recipecache)) {
                this.recipecache = null;
            }
            this.changed = false;
        }
        if (this.fuel > 0) {
            --this.fuel;
            if ((this.fuel & 1) != 0 && lv instanceof ServerLevel) {
                ServerLevel slv = (ServerLevel)lv;
                slv.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.13, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
            }
        }
        if (this.fuel == 0 && this.recipecache != null && (burn = ForgeHooks.getBurnTime((ItemStack)(fuelslot = this.itemHandler.getStackInSlot(6)), (RecipeType)RecipeType.f_44108_)) != 0) {
            this.fuel = burn;
            this.maxfuel = burn;
            this.itemHandler.extractItem(6, 1, false);
        }
        if (this.fuel > 0 && this.recipecache != null) {
            ++this.progress;
            if (this.progress >= 200) {
                this.progress = 0;
                List<Ingredient> ingredients = this.recipecache.getInputs();
                int testtubes = this.consumeIngredient(ingredients, false);
                ItemStack dinner = this.recipecache.getOutput();
                ItemStackUtil.addStackToSlot(this.itemHandler, 9, dinner);
                ItemStackUtil.addStackToSlot(this.itemHandler, 8, new ItemStack((ItemLike)ChemiItems.TESTTUBE.get(), testtubes));
                this.itemHandler.extractItem(7, this.recipecache.getOutputCount(), false);
                this.changed = true;
            }
        }
    }

    private int consumeIngredient(List<Ingredient> ingredients, boolean simulate) {
        int testtubes = 0;
        block0: for (Ingredient ingredient : ingredients) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (!ingredient.test(stack)) continue;
                if (!simulate) {
                    this.itemHandler.extractItem(i, 1, false);
                }
                if (!(stack.m_41720_() instanceof LiquidKitchen)) continue block0;
                ++testtubes;
                continue block0;
            }
        }
        return testtubes;
    }

    private boolean recipeInsertable(CookingRecipe recipe) {
        ItemStack out = recipe.getOutput();
        int testtubes = this.consumeIngredient(recipe.getInputs(), true);
        ItemStack bowls = this.itemHandler.getStackInSlot(7);
        boolean canOutput = ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(9), out);
        boolean canReturn = ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(8), new ItemStack((ItemLike)ChemiItems.TESTTUBE.get(), testtubes));
        boolean hasBowls = bowls.m_41720_() == Items.f_42399_ && bowls.m_41613_() >= recipe.getOutputCount();
        return canOutput && canReturn && hasBowls;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }
}

