/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.item.bioreagent.BioGrowingPlate;
import kandango.reagenica.item.bioreagent.BioReagent;
import kandango.reagenica.item.burnable.HeatProvidingItem;
import kandango.reagenica.recipes.ReagentMixingRecipe;
import kandango.reagenica.recipes.items.IngredientWithCount;
import kandango.reagenica.screen.ExperimentMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DraftChamberBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(13){

        protected void onContentsChanged(int slot) {
            DraftChamberBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot < 6) {
                return true;
            }
            if (slot < 9) {
                return false;
            }
            if (slot < 11) {
                return true;
            }
            return slot <= 13;
        }
    };
    private boolean cachedFire = false;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> new DraftChamberItemHandler(this.itemHandler));

    public DraftChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DRAFT_CHAMBER.get(), pos, state);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.draft_chamber");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ExperimentMenu(id, inv, this);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
    }

    public void mixButton(boolean shift) {
        if (shift) {
            for (int i = 0; i < 64 && this.tryMixRecipe(); ++i) {
            }
        } else {
            this.tryMixRecipe();
        }
    }

    private boolean tryMixRecipe() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return false;
        }
        if (lv.f_46443_) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(4);
        container.m_6836_(0, this.itemHandler.getStackInSlot(9));
        container.m_6836_(1, this.itemHandler.getStackInSlot(10));
        container.m_6836_(2, this.itemHandler.getStackInSlot(11));
        container.m_6836_(3, this.itemHandler.getStackInSlot(12));
        Optional<ReagentMixingRecipe> recipeOpt = ReagentMixingRecipe.getRecipe((Container)container, lv);
        if (recipeOpt.map(r -> r.getOutputA().m_41720_() == ChemiItems.GROWING_PLATE.get()).orElse(false).booleanValue()) {
            boolean swapped = false;
            ItemStack stackPlate = this.itemHandler.getStackInSlot(9).m_41777_();
            ItemStack stackParent = this.itemHandler.getStackInSlot(10).m_41777_();
            if (stackParent.m_41720_() == ChemiItems.MEDIUM_PLATE.get()) {
                ItemStack cache = stackPlate;
                stackPlate = stackParent;
                stackParent = cache;
                swapped = true;
            }
            ItemStack platestack = BioGrowingPlate.getPlateFromParent(stackPlate, stackParent);
            if (stackParent.m_41720_() instanceof BioReagent) {
                ItemStack after = ItemStackUtil.getDamagedItem(stackParent, 80, () -> ItemStack.f_41583_);
                this.itemHandler.setStackInSlot(swapped ? 9 : 10, after);
            } else {
                this.itemHandler.extractItem(swapped ? 9 : 10, 1, false);
            }
            this.itemHandler.extractItem(swapped ? 10 : 9, 1, false);
            ItemStackUtil.insertOrElseThrow(lv, this.f_58858_, this.itemHandler, platestack, 6, 9);
        } else if (recipeOpt.isPresent()) {
            ReagentMixingRecipe recipe = recipeOpt.orElseThrow();
            ResultInserts ins = this.getInsertSlot(recipe);
            if (ins.success) {
                this.consume(recipe);
                if (this.itemHandler.getStackInSlot(ins.r1()).m_41619_()) {
                    this.itemHandler.setStackInSlot(ins.r1(), recipe.getOutputA().m_41777_());
                } else {
                    this.itemHandler.getStackInSlot(ins.r1()).m_41769_(recipe.getOutputA().m_41613_());
                    this.itemHandler.setStackInSlot(ins.r1(), this.itemHandler.getStackInSlot(ins.r1()));
                }
                if (!recipe.getOutputB().m_41619_()) {
                    if (this.itemHandler.getStackInSlot(ins.r2()).m_41619_()) {
                        this.itemHandler.setStackInSlot(ins.r2(), recipe.getOutputB().m_41777_());
                    } else {
                        this.itemHandler.getStackInSlot(ins.r2()).m_41769_(recipe.getOutputB().m_41613_());
                        this.itemHandler.setStackInSlot(ins.r2(), this.itemHandler.getStackInSlot(ins.r2()));
                    }
                }
                if (recipe.isHeatRequired()) {
                    ItemStack stack = this.itemHandler.getStackInSlot(11);
                    if (stack.m_150930_((Item)ChemiItems.EASY_TORCH.get())) {
                        ItemStackUtil.damageItemInSlot(this.itemHandler, 11, 1, () -> ItemStack.f_41583_);
                    } else {
                        ItemStackUtil.damageItemInSlot(this.itemHandler, 11, 1, () -> {
                            stack.m_41721_(stack.m_41776_());
                            return stack;
                        });
                    }
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    private ResultInserts getInsertSlot(ReagentMixingRecipe recipe) {
        ItemStack res1 = recipe.getOutputA();
        ItemStack res2 = recipe.getOutputB();
        int r1 = -1;
        int r2 = -1;
        for (int i = 6; i <= 8; ++i) {
            if (r1 == -1 && ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(i), res1)) {
                r1 = i;
                continue;
            }
            if (r2 != -1 || !ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(i), res2)) continue;
            r2 = i;
        }
        return new ResultInserts(r1, r2, r1 != -1 && r2 != -1);
    }

    private void consume(ReagentMixingRecipe recipe) {
        block0: for (IngredientWithCount item : recipe.getInputs()) {
            for (int i = 9; i <= 10; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (!item.test(stack)) continue;
                this.itemHandler.extractItem(i, item.getCount(), false);
                continue block0;
            }
        }
        if (!recipe.getCatalyst().m_43947_()) {
            ItemStack stack = this.itemHandler.getStackInSlot(12);
            this.itemHandler.setStackInSlot(12, ItemStackUtil.getDamagedItem(stack, 1, () -> ItemStack.f_41583_));
        }
    }

    public boolean hasActiveFire() {
        ItemStack stack = this.itemHandler.getStackInSlot(11);
        return stack.m_41720_() instanceof HeatProvidingItem && stack.m_41773_() < stack.m_41776_();
    }

    public boolean isFireActiveClient() {
        return this.cachedFire;
    }

    public ContainerData getContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                if (index == 0) {
                    return DraftChamberBlockEntity.this.hasActiveFire() ? 1 : 0;
                }
                throw new IllegalArgumentException("Mod Internal Error.");
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    DraftChamberBlockEntity.this.cachedFire = value != 0;
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    protected boolean canAddStack(ItemStack insert, ItemStack origin) {
        if (insert.m_41619_() || origin.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)origin, (ItemStack)insert) && origin.m_41613_() + insert.m_41613_() <= origin.m_41741_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    private record ResultInserts(int r1, int r2, boolean success) {
    }

    private class DraftChamberItemHandler
    implements IItemHandler {
        private final ItemStackHandler handler;

        public DraftChamberItemHandler(ItemStackHandler handler) {
            this.handler = handler;
        }

        public int getSlots() {
            return this.handler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot < 6 ? this.handler.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 6 && slot < 9) {
                return this.handler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.handler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.handler.isItemValid(slot, stack);
        }
    }
}

