/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.FractionalDistillerBottom;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncQuadFluidTanksPacket;
import kandango.reagenica.recipes.FractionalDistillerRecipe;
import kandango.reagenica.screen.FractionalDistillerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class FractionalDistillerBlockEntity
extends BlockEntity
implements MenuProvider,
ITickableBlockEntity {
    private final int SLOTCOUNT = 10;
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            FractionalDistillerBlockEntity.this.m_6596_();
            FractionalDistillerBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (slot == 0) {
                return true;
            }
            if (slot == 1) {
                return false;
            }
            return slot % 2 == 0;
        }
    };
    private final FluidTank fluidTank_in = new FluidTank(8000){

        protected void onContentsChanged() {
            FractionalDistillerBlockEntity.this.m_6596_();
            FractionalDistillerBlockEntity.this.dirty = true;
            FractionalDistillerBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank fluidTank_top = new FluidTank(8000){

        protected void onContentsChanged() {
            FractionalDistillerBlockEntity.this.m_6596_();
            FractionalDistillerBlockEntity.this.dirty = true;
            FractionalDistillerBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank fluidTank_bottom = new FluidTank(8000){

        protected void onContentsChanged() {
            FractionalDistillerBlockEntity.this.m_6596_();
            FractionalDistillerBlockEntity.this.dirty = true;
            FractionalDistillerBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank fluidTank_water = new FluidTank(8000, x -> x.getFluid() == Fluids.f_76193_){

        protected void onContentsChanged() {
            FractionalDistillerBlockEntity.this.m_6596_();
            FractionalDistillerBlockEntity.this.dirty = true;
            FractionalDistillerBlockEntity.this.syncFluidToClient();
        }
    };
    private int progress;
    private int fuel = 0;
    private int fuelmax = 1600;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).fuelslot(0).outputslot(1).build());
    private final LazyOptional<IFluidHandler> topTankLazyOptional = LazyOptional.of(() -> this.fluidTank_top);
    private final LazyOptional<IFluidHandler> lowerLazyOptional = LazyOptional.of(() -> new LowerFluidHandler());
    private final LazyOptional<IFluidHandler> waterTankLazyOptional = LazyOptional.of(() -> this.fluidTank_water);
    private boolean dirty = true;
    @Nullable
    private FractionalDistillerRecipe cachedRecipe;

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int p) {
        this.fuel = p;
    }

    public int getFuelMax() {
        return this.fuelmax;
    }

    public void setFuelMax(int p) {
        this.fuelmax = p;
    }

    public FractionalDistillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FRACTIONAL_DISTILLER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.fluidTank_in.readFromNBT(tag.m_128469_("InputTank"));
        this.fluidTank_top.readFromNBT(tag.m_128469_("TopTank"));
        this.fluidTank_bottom.readFromNBT(tag.m_128469_("BottomTank"));
        this.fluidTank_water.readFromNBT(tag.m_128469_("WaterTank"));
        if (this.itemHandler.getSlots() != 10) {
            ListTag substituetag = new ListTag();
            for (int i = 0; i < 10; ++i) {
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                ItemStack.f_41583_.m_41777_().m_41739_(itemTag);
                substituetag.add((Object)itemTag);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)substituetag);
            nbt.m_128405_("Size", 10);
            this.itemHandler.deserializeNBT(nbt);
            ChemistryMod.LOGGER.warn("Invalid length tag at {}, using empty substitue.", (Object)this.m_58899_());
        }
        this.fuel = tag.m_128451_("Fuel");
        this.fuelmax = tag.m_128451_("MaxFuel");
        this.progress = tag.m_128451_("Progress");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.fluidTank_in.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.fluidTank_top.writeToNBT(fluidTag);
        tag.m_128365_("TopTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.fluidTank_bottom.writeToNBT(fluidTag);
        tag.m_128365_("BottomTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.fluidTank_water.writeToNBT(fluidTag);
        tag.m_128365_("WaterTank", (Tag)fluidTag);
        super.m_183515_(tag);
        tag.m_128405_("Fuel", this.fuel);
        tag.m_128405_("MaxFuel", this.fuelmax);
        tag.m_128405_("Progress", this.progress);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == Direction.UP) {
                return this.topTankLazyOptional.cast();
            }
            if (side == Direction.NORTH || side == Direction.SOUTH || side == Direction.EAST || side == Direction.WEST) {
                Direction facing = (Direction)this.m_58900_().m_61143_((Property)FractionalDistillerBottom.FACING);
                if (side == facing.m_122424_()) {
                    return this.waterTankLazyOptional.cast();
                }
                return this.lowerLazyOptional.cast();
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new FractionalDistillerMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.fractional_distiller");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncQuadFluidTanksPacket(this.f_58858_, this.fluidTank_in.getFluid().copy(), this.fluidTank_top.getFluid().copy(), this.fluidTank_bottom.getFluid().copy(), this.fluidTank_water.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        boolean dirtyflag = false;
        if (this.dirty) {
            ItemStack fuelstack;
            int burn;
            boolean in;
            boolean out;
            if (!this.itemHandler.getStackInSlot(2).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 2, 3, this.fluidTank_in);
                in = FluidItemConverter.drainfromItem(this.itemHandler, 2, 3, this.fluidTank_in);
                dirtyflag |= in || out;
            }
            if (!this.itemHandler.getStackInSlot(4).m_41619_()) {
                dirtyflag |= FluidItemConverter.draintoItem(this.itemHandler, 4, 5, this.fluidTank_top);
            }
            if (!this.itemHandler.getStackInSlot(6).m_41619_()) {
                dirtyflag |= FluidItemConverter.draintoItem(this.itemHandler, 6, 7, this.fluidTank_bottom);
            }
            if (!this.itemHandler.getStackInSlot(8).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 8, 9, this.fluidTank_water);
                in = FluidItemConverter.drainfromItem(this.itemHandler, 8, 9, this.fluidTank_water);
                dirtyflag |= in || out;
            }
            this.cachedRecipe = FractionalDistillerRecipe.getRecipe(this.fluidTank_in.getFluid(), lv).filter(r -> this.isInsertable((FractionalDistillerRecipe)r)).orElse(null);
            if (this.cachedRecipe != null && !this.itemHandler.getStackInSlot(0).m_41619_() && this.fuel == 0 && (burn = ItemStackUtil.getFuelExceptforLava(fuelstack = this.itemHandler.getStackInSlot(0))) > 0) {
                this.fuel = burn;
                this.fuelmax = burn;
                this.itemHandler.extractItem(0, 1, false);
            }
        }
        if (this.meetHeatAndCoolCondition() && this.cachedRecipe != null) {
            FractionalDistillerRecipe recipe = this.cachedRecipe;
            FluidStack input = recipe.getInput();
            FluidStack top = recipe.getTop();
            FluidStack bottom = recipe.getBottom();
            ItemStack residual = recipe.getResidual();
            ItemStack inslot = this.itemHandler.getStackInSlot(1);
            if (FluidStackUtil.canFullyInsertToTank(top, this.fluidTank_top) && FluidStackUtil.canFullyInsertToTank(bottom, this.fluidTank_bottom) && ItemStackUtil.canAddStack(inslot, residual)) {
                ++this.progress;
                if (this.progress >= 200) {
                    this.progress = 0;
                    this.fluidTank_in.drain(input, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidTank_top.fill(top, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidTank_bottom.fill(bottom, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidTank_water.drain(25, IFluidHandler.FluidAction.EXECUTE);
                    this.itemHandler.setStackInSlot(1, ItemStackUtil.addStack(inslot, residual));
                    dirtyflag |= true;
                }
            } else {
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        this.dirty = dirtyflag;
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel == 0) {
            this.dirty = true;
        }
    }

    private boolean meetHeatAndCoolCondition() {
        return this.fluidTank_water.getFluid().getAmount() >= 25 && this.fuel > 0;
    }

    private boolean isInsertable(FractionalDistillerRecipe recipe) {
        boolean top = FluidStackUtil.canFullyInsertToTank(recipe.getTop(), this.fluidTank_top);
        boolean bottom = FluidStackUtil.canFullyInsertToTank(recipe.getBottom(), this.fluidTank_bottom);
        boolean item = ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(1), recipe.getResidual());
        return top && bottom && item;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTankInput() {
        return this.fluidTank_in;
    }

    public FluidTank getFluidTankTop() {
        return this.fluidTank_top;
    }

    public FluidTank getFluidTankBottom() {
        return this.fluidTank_bottom;
    }

    public FluidTank getFluidTankWater() {
        return this.fluidTank_water;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.topTankLazyOptional.invalidate();
        this.lowerLazyOptional.invalidate();
        this.waterTankLazyOptional.invalidate();
    }

    private final class LowerFluidHandler
    implements IFluidHandler {
        private LowerFluidHandler() {
        }

        public int getTanks() {
            return 2;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return FractionalDistillerBlockEntity.this.fluidTank_in.getFluid();
            }
            if (tank == 1) {
                return FractionalDistillerBlockEntity.this.fluidTank_bottom.getFluid();
            }
            throw new IllegalArgumentException();
        }

        public int getTankCapacity(int tank) {
            if (tank == 0) {
                return FractionalDistillerBlockEntity.this.fluidTank_in.getCapacity();
            }
            if (tank == 1) {
                return FractionalDistillerBlockEntity.this.fluidTank_bottom.getCapacity();
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            if (tank == 0) {
                return true;
            }
            if (tank == 1) {
                return false;
            }
            throw new IndexOutOfBoundsException();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return FractionalDistillerBlockEntity.this.fluidTank_in.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FractionalDistillerBlockEntity.this.fluidTank_bottom.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FractionalDistillerBlockEntity.this.fluidTank_bottom.drain(maxDrain, action);
        }
    }
}

