/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.screen.HaberBoschMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class HaberBoschBlockEntity
extends BlockEntity
implements MenuProvider,
ITickableBlockEntity {
    public static final int REACTION_UNIT = 100;
    private final ItemStackHandler itemHandler = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            HaberBoschBlockEntity.this.m_6596_();
            HaberBoschBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot == 0) {
                return true;
            }
            return slot % 2 == 1;
        }
    };
    private final FluidTank outputTank = new FluidTank(6000){

        protected void onContentsChanged() {
            HaberBoschBlockEntity.this.m_6596_();
            HaberBoschBlockEntity.this.dirty = true;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_(ChemiFluids.AMMONIA.getFluid());
        }
    };
    private final FluidTank nitrogenTank = new FluidTank(6000){

        protected void onContentsChanged() {
            HaberBoschBlockEntity.this.m_6596_();
            HaberBoschBlockEntity.this.dirty = true;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_(ChemiFluids.NITROGEN.getFluid());
        }
    };
    private final FluidTank hydrogenTank = new FluidTank(6000){

        protected void onContentsChanged() {
            HaberBoschBlockEntity.this.m_6596_();
            HaberBoschBlockEntity.this.dirty = true;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_(ChemiFluids.HYDROGEN.getFluid());
        }
    };
    private int progress = 0;
    private int burntime = 0;
    private int maxburntime = 0;
    private boolean dirty = true;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).fuelslot(0).outputslot(2, 4, 6).build());
    private final LazyOptional<IFluidHandler> fluidTankLazyOptional = LazyOptional.of(() -> new HaberBoschFluidHandler(this.hydrogenTank, this.nitrogenTank, this.outputTank));

    public FluidStack getOutputFluid() {
        return this.outputTank.getFluid();
    }

    public void setOutputAmount(int amount) {
        if (amount == 0) {
            this.outputTank.setFluid(FluidStack.EMPTY);
        } else {
            this.outputTank.setFluid(new FluidStack(ChemiFluids.AMMONIA.getFluid(), amount));
        }
    }

    public FluidStack getNitroFluid() {
        return this.nitrogenTank.getFluid();
    }

    public void setNitroAmount(int amount) {
        if (amount == 0) {
            this.nitrogenTank.setFluid(FluidStack.EMPTY);
        } else {
            this.nitrogenTank.setFluid(new FluidStack(ChemiFluids.NITROGEN.getFluid(), amount));
        }
    }

    public FluidStack getHydroFluid() {
        return this.hydrogenTank.getFluid();
    }

    public void setHydroAmount(int amount) {
        if (amount == 0) {
            this.hydrogenTank.setFluid(FluidStack.EMPTY);
        } else {
            this.hydrogenTank.setFluid(new FluidStack(ChemiFluids.HYDROGEN.getFluid(), amount));
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int v) {
        this.progress = v;
    }

    public int getBurntime() {
        return this.burntime;
    }

    public void setBurntime(int v) {
        this.burntime = v;
    }

    public int getMaxBurnTime() {
        return this.maxburntime;
    }

    public void setMaxBurnTime(int v) {
        this.maxburntime = v;
    }

    public HaberBoschBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HABER_BOSCH.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.outputTank.readFromNBT(tag.m_128469_("OutputTank"));
        this.nitrogenTank.readFromNBT(tag.m_128469_("NitrogenTank"));
        this.hydrogenTank.readFromNBT(tag.m_128469_("HydrogenTank"));
        this.progress = tag.m_128451_("Progress");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        FluidStackUtil.saveFluid(tag, "OutputTank", this.outputTank);
        FluidStackUtil.saveFluid(tag, "NitrogenTank", this.nitrogenTank);
        FluidStackUtil.saveFluid(tag, "HydrogenTank", this.hydrogenTank);
        tag.m_128405_("Progress", this.progress);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidTankLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new HaberBoschMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.haber_bosch");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            ItemStack fuelstack;
            int burn;
            boolean in;
            boolean out;
            if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 1, 2, this.nitrogenTank);
                in = FluidItemConverter.drainfromItem(this.itemHandler, 1, 2, this.nitrogenTank);
                dirtyflag |= in || out;
            }
            if (!this.itemHandler.getStackInSlot(3).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 3, 4, this.hydrogenTank);
                in = FluidItemConverter.drainfromItem(this.itemHandler, 3, 4, this.hydrogenTank);
                dirtyflag |= in || out;
            }
            if (!this.itemHandler.getStackInSlot(5).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 5, 6, this.outputTank);
                dirtyflag |= out;
            }
            if (this.burntime == 0 && this.isReady() && (burn = ForgeHooks.getBurnTime((ItemStack)(fuelstack = this.itemHandler.getStackInSlot(0)), (RecipeType)RecipeType.f_44108_)) > 0) {
                this.burntime = burn;
                this.maxburntime = burn;
                this.itemHandler.extractItem(0, 1, false);
                dirtyflag = true;
            }
        }
        if (this.burntime > 0) {
            --this.burntime;
            if (this.burntime == 0) {
                dirtyflag = true;
            }
            if (this.isReady()) {
                ++this.progress;
                if (this.progress >= 200) {
                    this.hydrogenTank.drain(150, IFluidHandler.FluidAction.EXECUTE);
                    this.nitrogenTank.drain(50, IFluidHandler.FluidAction.EXECUTE);
                    this.outputTank.fill(new FluidStack(ChemiFluids.AMMONIA.getFluid(), 100), IFluidHandler.FluidAction.EXECUTE);
                    this.progress = 0;
                    dirtyflag = true;
                }
            }
        } else if (this.progress != 0) {
            this.progress = Math.max(0, this.progress - 5);
        }
        this.dirty = dirtyflag;
    }

    private boolean isReady() {
        return this.hydrogenTank.getFluidAmount() >= 150 && this.nitrogenTank.getFluidAmount() >= 50 && this.outputTank.getSpace() >= 100;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidTankLazyOptional.invalidate();
    }

    private class HaberBoschFluidHandler
    implements IFluidHandler {
        final FluidTank hydroTank;
        final FluidTank nitroTank;
        final FluidTank outputTank;

        public HaberBoschFluidHandler(FluidTank t1, FluidTank t2, FluidTank t3) {
            this.hydroTank = t1;
            this.nitroTank = t2;
            this.outputTank = t3;
        }

        public int getTanks() {
            return 3;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getTankbyIndex(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getTankbyIndex(tank).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.getTankbyIndex(tank).isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid().m_6212_(ChemiFluids.HYDROGEN.getFluid())) {
                return this.hydroTank.fill(resource, action);
            }
            if (resource.getFluid().m_6212_(ChemiFluids.OXYGEN.getFluid())) {
                return this.nitroTank.fill(resource, action);
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.outputTank.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.outputTank.drain(maxDrain, action);
        }

        private FluidTank getTankbyIndex(int index) {
            if (index == 0) {
                return this.hydroTank;
            }
            if (index == 1) {
                return this.nitroTank;
            }
            if (index == 2) {
                return this.outputTank;
            }
            throw new IndexOutOfBoundsException("index" + index + "is out of range");
        }
    }
}

