/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiTags;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.LargeTankInterfaceBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.SimpleTankBlockEntity;
import kandango.reagenica.packet.LargeTankPropPacket;
import kandango.reagenica.packet.ModMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class LargeTankCoreBlockEntity
extends SimpleTankBlockEntity {
    @Nullable
    private TankSize size = null;
    private int tick = 20;

    public LargeTankCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends SimpleTankBlockEntity>)((BlockEntityType)ModBlockEntities.LARGE_TANK_CORE.get()), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.large_tank");
    }

    @Override
    protected int tankSize() {
        return 0;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        byte width = tag.m_128445_("Width");
        byte height = tag.m_128445_("Height");
        if (width > 0 && height > 0) {
            this.size = new TankSize(width, height);
        }
        this.fluidTank.setCapacity(tag.m_128451_("Capacity"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        TankSize size = this.size;
        tag.m_128344_("Width", size != null ? (byte)size.width : (byte)0);
        tag.m_128344_("Height", size != null ? (byte)size.height : (byte)0);
        tag.m_128405_("Capacity", this.fluidTank.getCapacity());
    }

    public AABB getRenderBoundingBox() {
        TankSize size = this.size;
        if (size == null) {
            return super.getRenderBoundingBox();
        }
        return new AABB((double)(this.f_58858_.m_123341_() - (size.width - 1)), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - (size.width - 1)), (double)(this.f_58858_.m_123341_() + size.width), (double)(this.f_58858_.m_123342_() + size.height), (double)(this.f_58858_.m_123343_() + size.width));
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        super.serverTick();
        if (this.tick >= 20) {
            this.tick = 0;
            TankSize newsize = this.testforTankStructure(lv);
            if (!Objects.equals(this.size, newsize)) {
                this.size = newsize;
                if (newsize != null) {
                    int width = newsize.width * 2 - 1;
                    int height = newsize.height;
                    this.fluidTank.setCapacity(width * width * (height - 1) * 48000);
                    this.notifyToInterfaces(lv, newsize);
                } else {
                    this.fluidTank.setCapacity(0);
                }
                this.syncSizeToClient();
            }
        } else {
            ++this.tick;
        }
    }

    @Nullable
    private TankSize testforTankStructure(@Nonnull Level lv) {
        int height;
        int temp_size = this.getFloorSize(lv);
        if (temp_size != 0 && (height = this.getHeight(lv, temp_size)) != 0) {
            return new TankSize(temp_size, height);
        }
        return null;
    }

    private int getFloorSize(@Nonnull Level lv) {
        int MAX_FLOOR = 4;
        BooleanArraySquare hasValidWall = new BooleanArraySquare(4);
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                hasValidWall.set(x, z, lv.m_8055_(this.f_58858_.m_7918_(x, 0, z)).m_204336_(ChemiTags.Blocks.TANK_BLOCKS));
            }
        }
        hasValidWall.set(0, 0, true);
        for (int size = 1; size <= 4; ++size) {
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    if (hasValidWall.get(x, z)) continue;
                    return size - 1;
                }
            }
        }
        return 4;
    }

    private int getHeight(@Nonnull Level lv, int floorsize) {
        int tempheight = 0;
        for (int y = 2; y <= 10; ++y) {
            BlockState state = lv.m_8055_(this.f_58858_.m_7918_(0, y, 0));
            if (state.m_60795_()) continue;
            if (!state.m_204336_(ChemiTags.Blocks.TANK_BLOCKS)) break;
            tempheight = y;
            break;
        }
        if (tempheight == 0) {
            return 0;
        }
        boolean failed = false;
        block1: for (int y = 1; y < tempheight; ++y) {
            for (int x = -floorsize; x <= floorsize; ++x) {
                for (int z = -floorsize; z <= floorsize; ++z) {
                    if (x == -floorsize || x == floorsize || z == floorsize || z == -floorsize) {
                        if (lv.m_8055_(this.f_58858_.m_7918_(x, y, z)).m_204336_(ChemiTags.Blocks.TANK_BLOCKS)) continue;
                        failed = true;
                        break block1;
                    }
                    if (lv.m_8055_(this.f_58858_.m_7918_(x, y, z)).m_60795_()) continue;
                    failed = true;
                    break block1;
                }
            }
        }
        if (failed) {
            return 0;
        }
        block4: for (int x = -floorsize; x <= floorsize; ++x) {
            for (int z = -floorsize; z <= floorsize; ++z) {
                if (lv.m_8055_(this.f_58858_.m_7918_(x, tempheight, z)).m_204336_(ChemiTags.Blocks.TANK_BLOCKS)) continue;
                failed = true;
                break block4;
            }
        }
        if (failed) {
            return 0;
        }
        return tempheight;
    }

    private void notifyToInterfaces(@Nonnull Level lv, @Nonnull TankSize size) {
        BlockPos.MutableBlockPos mutablePos = this.f_58858_.m_122032_();
        for (int x = -size.width; x <= size.width; ++x) {
            for (int z = -size.width; z <= size.width; ++z) {
                for (int y = 0; y <= size.height; ++y) {
                    mutablePos.m_122178_(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + y, this.f_58858_.m_123343_() + z);
                    if (!lv.m_46749_((BlockPos)mutablePos)) {
                        return;
                    }
                    BlockEntity be = lv.m_7702_((BlockPos)mutablePos);
                    if (!(be instanceof LargeTankInterfaceBlockEntity)) continue;
                    LargeTankInterfaceBlockEntity lti = (LargeTankInterfaceBlockEntity)be;
                    lti.setMaster(this.f_58858_);
                }
            }
        }
    }

    @Nullable
    public TankSize getTankSize() {
        return this.size;
    }

    public void receiveSizePacket(int width, int height, int capacity) {
        this.size = width > 0 && height > 0 ? new TankSize(width, height) : null;
        this.fluidTank.setCapacity(capacity);
        ChemistryMod.LOGGER.info("Received Packet: {},{},{}", new Object[]{width, height, capacity});
    }

    private void syncSizeToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new LargeTankPropPacket(this.f_58858_, this.size == null ? 0 : this.size.width, this.size == null ? 0 : this.size.height, this.fluidTank.getCapacity()));
        }
    }

    public record TankSize(int width, int height) {
    }

    private static class BooleanArraySquare {
        private boolean[][] array;
        private final int radius;

        public BooleanArraySquare(int radius) {
            this.radius = radius;
            int size = radius * 2 + 1;
            this.array = new boolean[size][size];
        }

        public void set(int x, int z, boolean value) {
            this.validate(x, z);
            this.array[x + this.radius][z + this.radius] = value;
        }

        public boolean get(int x, int z) {
            this.validate(x, z);
            return this.array[x + this.radius][z + this.radius];
        }

        private void validate(int x, int z) {
            if (-this.radius > x || x > this.radius || -this.radius > z || z > this.radius) {
                throw new IndexOutOfBoundsException("Index (" + x + "," + z + ") is invalid.");
            }
        }
    }
}

