/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.lang.ref.WeakReference;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.LargeTankCoreBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class LargeTankInterfaceBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos masterPos;
    @Nullable
    private WeakReference<LargeTankCoreBlockEntity> cachedBE;

    private Optional<LargeTankCoreBlockEntity> getMasterifPresentAndCache() {
        LargeTankCoreBlockEntity be;
        BlockPos master = this.masterPos;
        WeakReference<LargeTankCoreBlockEntity> cached = this.cachedBE;
        if (master == null) {
            return Optional.empty();
        }
        if (cached != null && (be = (LargeTankCoreBlockEntity)cached.get()) != null) {
            return Optional.of(be);
        }
        Level lv = this.f_58857_;
        if (lv != null) {
            if (lv.m_46749_(master)) {
                BlockEntity be2 = lv.m_7702_(master);
                if (be2 instanceof LargeTankCoreBlockEntity) {
                    LargeTankCoreBlockEntity tank = (LargeTankCoreBlockEntity)be2;
                    this.cachedBE = new WeakReference<LargeTankCoreBlockEntity>(tank);
                    return Optional.of(tank);
                }
                ChemistryMod.LOGGER.warn("Master Pos " + master.m_123344_() + " was not BE looking for.");
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public LargeTankInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LARGE_TANK_INTERFACE.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.masterPos = tag.m_128471_("HasMaster") ? BlockPos.m_122022_((long)tag.m_128454_("MasterPos")) : null;
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        BlockPos master = this.masterPos;
        if (master != null) {
            tag.m_128356_("MasterPos", master.m_121878_());
            tag.m_128379_("HasMaster", true);
        } else {
            tag.m_128379_("HasMaster", false);
        }
        super.m_183515_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void setMaster(BlockPos pos) {
        this.masterPos = pos;
        this.cachedBE = null;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        ChemistryMod.LOGGER.debug("Master set:{}", (Object)pos.m_123344_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return this.getMasterifPresentAndCache().map(tank -> tank.getCapability(cap, side)).orElse(LazyOptional.empty());
    }

    public Optional<LargeTankCoreBlockEntity> getMasterBlockEntity() {
        return this.getMasterifPresentAndCache();
    }
}

