/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.OnsenFiller;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.packet.ISingleTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncFluidPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public class OnsenFillerBlockEntity
extends BlockEntity
implements ITickableBlockEntity,
ISingleTankBlock {
    private final FluidTank fluidTank = new FluidTank(1000){

        protected void onContentsChanged() {
            OnsenFillerBlockEntity.this.m_6596_();
        }
    };
    private int cooldown = 20;

    public OnsenFillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ONSEN_FILLER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTank.readFromNBT(tag.m_128469_("Tank"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        FluidStackUtil.saveFluid(tag, "Tank", this.fluidTank);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        BlockEntity below = lv.m_7702_(this.f_58858_.m_7495_());
        if (below != null) {
            below.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(this::drawFluid);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.syncFluidToClient();
            this.cooldown = 20;
            if (this.fluidTank.getFluidAmount() >= 1000) {
                Direction facing = BlockUtil.getStatus(lv.m_8055_(this.f_58858_), OnsenFiller.FACING).orElse(null);
                this.fillWater(lv, facing, this.fluidTank.getFluid().getFluid());
            }
        }
    }

    private void drawFluid(IFluidHandler another) {
        int max = this.fluidTank.getCapacity();
        int current = this.fluidTank.getFluidAmount();
        if (current < max) {
            int drawing = Math.min(max - current, 100);
            FluidStack stack = another.drain(drawing, IFluidHandler.FluidAction.EXECUTE);
            this.fluidTank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void fillWater(@Nonnull Level lv, @Nullable Direction facing, @Nullable Fluid fluid) {
        int MAX_BELOW = 16;
        if (facing == null) {
            return;
        }
        BlockPos startPos = this.f_58858_.m_121945_(facing);
        BlockPos originPos = null;
        for (int i = 1; i < 16; ++i) {
            BlockPos targetPos = startPos.m_6625_(i);
            if (!this.isWall(lv.m_8055_(targetPos), fluid)) continue;
            if (i < 2) break;
            originPos = targetPos.m_7494_();
            this.findLowestFillingPos(lv, originPos, fluid).ifPresent(pos -> this.placeSource(lv, (BlockPos)pos, fluid));
            break;
        }
    }

    private void placeSource(@Nonnull Level lv, BlockPos pos, Fluid fluid) {
        this.fluidTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        BlockState state = fluid.m_76145_().m_76188_();
        lv.m_7731_(pos, state, 3);
    }

    private boolean isWall(BlockState state, Fluid fillingFluid) {
        FluidState fs = state.m_60819_();
        boolean is_same_fluid = fs.m_76152_().m_6212_(fillingFluid);
        boolean is_solid = this.isSolidBlock(state, fillingFluid);
        return !is_same_fluid && is_solid;
    }

    private Optional<BlockPos> findLowestFillingPos(@Nonnull Level lv, BlockPos origin, Fluid fluid) {
        int MAX_FLUID_VISIT = 1000;
        int watchdog = 0;
        int lowest_Y = 10000;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos fillCandidatePos = null;
        queue.add(origin);
        visited.add(origin);
        while (!queue.isEmpty() && watchdog < 1000) {
            ++watchdog;
            BlockPos pos = (BlockPos)queue.poll();
            if (pos.m_123342_() < lowest_Y && this.shouldFill(lv, pos, fluid)) {
                lowest_Y = pos.m_123342_();
                fillCandidatePos = pos;
            }
            for (Direction dir : Direction.values()) {
                BlockPos next = pos.m_121945_(dir);
                if (visited.contains(next) || !lv.m_46749_(next) || next.m_123342_() >= this.f_58858_.m_123342_() || !this.isSameFluid(lv, next, fluid) && (!this.isSameFluid(lv, pos, fluid) || !lv.m_8055_(next).m_60795_())) continue;
                queue.add(next);
                visited.add(next);
            }
        }
        return Optional.ofNullable(fillCandidatePos);
    }

    private boolean shouldFill(Level lv, BlockPos pos, Fluid fillingFluid) {
        BlockState state = lv.m_8055_(pos);
        FluidState fs = state.m_60819_();
        boolean is_air = state.m_60795_();
        boolean is_source = fs.m_164512_(fillingFluid);
        boolean is_same_fluid = this.isSameFluid(state, fillingFluid);
        boolean is_closed = this.isClosed(lv, pos, fillingFluid);
        return is_closed && (is_air || !is_source && is_same_fluid);
    }

    private boolean isSameFluid(Level lv, BlockPos pos, Fluid fluid) {
        return this.isSameFluid(lv.m_8055_(pos), fluid);
    }

    private boolean isSameFluid(BlockState state, Fluid fluid) {
        FluidState fs = state.m_60819_();
        boolean answer = fs.getFluidType() == fluid.getFluidType();
        return answer;
    }

    private boolean isClosed(Level lv, BlockPos origin, Fluid fluid) {
        int MAX_SIZE = 201;
        int count = 0;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(origin);
        visited.add(origin);
        while (!queue.isEmpty() && count < 201) {
            ++count;
            BlockPos pos = (BlockPos)queue.poll();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos next = pos.m_121945_(dir);
                if (visited.contains(next) || !lv.m_46749_(next)) continue;
                BlockState nextState = lv.m_8055_(next);
                if (!this.isSameFluid(lv, next, fluid) && this.isSolidBlock(nextState, fluid)) continue;
                queue.add(next);
                visited.add(next);
            }
        }
        return count < 201;
    }

    private boolean isSolidBlock(BlockState state, Fluid fluid) {
        if (state.m_60795_()) {
            return false;
        }
        return !state.m_60722_(fluid);
    }

    @Override
    public void receivePacket(FluidStack fluid) {
        this.fluidTank.setFluid(fluid);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncFluidPacket(this.f_58858_, this.fluidTank.getFluid().copy()));
        }
    }

    public FluidStack getRenderingFluid() {
        return this.fluidTank.getFluid();
    }
}

