/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiGameRules;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.fluidhandlers.DrainOnlyFluidHandler;
import kandango.reagenica.block.entity.lamp.ILampController;
import kandango.reagenica.block.entity.lamp.LampControllerHelper;
import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.fluid.hotspring.OnsenTypes;
import kandango.reagenica.packet.ISingleTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncFluidPacket;
import kandango.reagenica.screen.OnsenMinerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class OnsenMinerBlockEntity
extends BlockEntity
implements MenuProvider,
ITickableBlockEntity,
ISingleTankBlock,
ILampController {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            OnsenMinerBlockEntity.this.m_6596_();
            OnsenMinerBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return slot == 0;
        }
    };
    protected final FluidTank fluidTank = new FluidTank(8000){

        protected void onContentsChanged() {
            OnsenMinerBlockEntity.this.m_6596_();
            OnsenMinerBlockEntity.this.syncFluidToClient();
        }
    };
    @Nullable
    private OnsenTypes onsenType;
    private boolean dirty = false;
    private int tick = 10;
    private int turbo = 0;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new DrainOnlyFluidHandler(this.fluidTank));
    private final LampControllerHelper<OnsenMinerBlockEntity> lamphelper = new LampControllerHelper<OnsenMinerBlockEntity>(this);

    public OnsenMinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ONSEN_MINER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.fluidTank.readFromNBT(tag.m_128469_("Tank"));
        this.turbo = tag.m_128451_("Turbo");
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        FluidStackUtil.saveFluid(tag, "Tank", this.fluidTank);
        tag.m_128405_("Turbo", this.turbo);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncFluidPacket(this.f_58858_, this.fluidTank.getFluid().copy()));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new OnsenMinerMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.hotspring_miner");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.dirty |= FluidItemConverter.draintoItem(this.itemHandler, 0, 1, this.fluidTank);
            }
        }
        if (!ChemiGameRules.isOnsenGenerate(lv)) {
            return;
        }
        if (this.onsenType == null && lv instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)lv;
            this.onsenType = OnsenTypes.getOnsenTypeAt(slv, this.f_58858_);
        }
        OnsenTypes onsen = this.onsenType;
        if (this.turbo > 0) {
            --this.turbo;
        }
        if (this.tick >= 10) {
            this.tick = 0;
            if (onsen != null) {
                Fluid onsenwater = onsen.getFluid();
                FluidStack onsenWaterStack = new FluidStack(onsenwater, this.turbo == 0 ? 25 : 500);
                this.fluidTank.fill(onsenWaterStack, IFluidHandler.FluidAction.EXECUTE);
            }
            int max = this.fluidTank.getCapacity();
            int amount = this.fluidTank.getFluidAmount();
            if (amount == 0) {
                this.lamphelper.changeLampState(LampStates.YELLOW);
            } else if ((float)amount >= (float)max * 0.98f) {
                this.lamphelper.changeLampState(LampStates.RED);
            } else {
                this.lamphelper.changeLampState(LampStates.GREEN);
            }
        } else {
            ++this.tick;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }

    @Override
    public void receivePacket(FluidStack fluid) {
        this.fluidTank.setFluid(fluid);
    }

    @Override
    public LampStates getLampStates() {
        return this.lamphelper.getLampStates();
    }

    @Override
    public void receivePacket(LampStates states) {
        this.lamphelper.receivePacket(states);
    }
}

