/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.itemhandler.ChemiItemHandler;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.lamp.ILampController;
import kandango.reagenica.block.entity.lamp.LampControllerHelper;
import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.ReactorRecipe;
import kandango.reagenica.screen.ReactorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class ReactorBlockEntity
extends BlockEntity
implements MenuProvider,
ITickableBlockEntity,
IDualTankBlock,
ILampController {
    private final int SLOTCOUNT = 11;
    private final ChemiItemHandler itemHandler = new ChemiItemHandler(11){

        protected void onContentsChanged(int slot) {
            ReactorBlockEntity.this.m_6596_();
            ReactorBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return slot != 10;
        }

        public int getSlotLimit(int slot) {
            return slot < 9 ? 1 : 64;
        }
    };
    private final FluidTank fluidTank_main = new FluidTank(30000){

        protected void onContentsChanged() {
            ReactorBlockEntity.this.m_6596_();
            ReactorBlockEntity.this.dirty = true;
            ReactorBlockEntity.this.syncFluidToClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_(ChemiFluids.DISTILLED_WATER.getFluid());
        }
    };
    private final FluidTank fluidTank_heat = new FluidTank(4000){

        protected void onContentsChanged() {
            ReactorBlockEntity.this.m_6596_();
            ReactorBlockEntity.this.dirty = true;
            ReactorBlockEntity.this.syncFluidToClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_(ChemiFluids.HEATED_WATER.getFluid());
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).specificFluidInputSlot(ChemiFluids.DISTILLED_WATER.getFluid(), 9).build());
    private final LazyOptional<IFluidHandler> waterTankLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.fluidTank_main, this.fluidTank_heat));
    private boolean dirty = true;
    private boolean isActive = false;
    private boolean isSCRAMed;
    private boolean wasPowered = false;
    private ReactorSlotState[] slotstates = new ReactorSlotState[]{new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState(), new ReactorSlotState()};
    private final LampControllerHelper<ReactorBlockEntity> lamphelper = new LampControllerHelper<ReactorBlockEntity>(this);

    public boolean isSCRAMed() {
        return this.isSCRAMed;
    }

    public void setSCRAMed(boolean p) {
        this.isSCRAMed = p;
    }

    public ReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REACTOR.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        if (this.itemHandler.getSlots() != 11) {
            this.itemHandler.setSize(11);
            ListTag tagList = tag.m_128469_("Inventory").m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot >= 0 && slot < 9) {
                    this.itemHandler.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)itemTags));
                    continue;
                }
                ChemistryMod.LOGGER.error("Reactor at {} has invalid inventory NBT, ignoring it.", (Object)this.m_58899_());
            }
            ChemistryMod.LOGGER.info("Reactor at {} has older inventory NBT, expanded automatically.", (Object)this.m_58899_());
        }
        this.fluidTank_main.readFromNBT(tag.m_128469_("MainTank"));
        this.fluidTank_heat.readFromNBT(tag.m_128469_("HeatTank"));
        this.isSCRAMed = tag.m_128471_("SCRAM");
        this.isActive = tag.m_128471_("Active");
    }

    public void onLoad() {
        if (this.f_58857_ != null) {
            this.wasPowered = this.f_58857_.m_276867_(this.f_58858_);
        }
        super.onLoad();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.fluidTank_main.writeToNBT(fluidTag);
        tag.m_128365_("MainTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.fluidTank_heat.writeToNBT(fluidTag);
        tag.m_128365_("HeatTank", (Tag)fluidTag);
        tag.m_128379_("SCRAM", this.isSCRAMed);
        tag.m_128379_("Active", this.isActive);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.waterTankLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ReactorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.reactor");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.fluidTank_main.getFluid().copy(), this.fluidTank_heat.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            if (!this.itemHandler.getStackInSlot(9).m_41619_()) {
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 9, this.fluidTank_main);
                this.dirty |= in;
            }
            if (!this.isSCRAMed) {
                boolean oldActive = this.isActive;
                this.isActive = false;
                for (int i = 0; i != 9; ++i) {
                    this.slotstates[i].recalc((IItemHandler)this.itemHandler, i, lv);
                    if (this.slotstates[i].getSlotType() != ReactorSlot.FUEL) continue;
                    this.isActive = true;
                }
                if (oldActive != this.isActive) {
                    this.m_6596_();
                    lv.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
            }
        }
        if (this.isActive && !this.isSCRAMed) {
            long time = lv.m_46467_();
            if (time % 20L == 0L) {
                int energy = 0;
                for (int i = 0; i != 9; ++i) {
                    RandomSource rand;
                    ReactorRecipe recipe;
                    ReactorSlot type = this.slotstates[i].getSlotType();
                    if (type == ReactorSlot.FUEL) {
                        this.decreaseFuel(i);
                        energy += 10 + 5 * this.slotstates[i].getAmplify();
                        continue;
                    }
                    if (type != ReactorSlot.RECIPE || (recipe = this.slotstates[i].getRecipe()) == null || (rand = lv.m_213780_()).m_188503_(1000) >= this.slotstates[i].getAmplify()) continue;
                    this.itemHandler.setStackInSlot(i, recipe.getOutput().m_41777_());
                }
                this.fluidTank_main.drain(energy, IFluidHandler.FluidAction.EXECUTE);
                this.fluidTank_heat.fill(new FluidStack(ChemiFluids.HEATED_WATER.getFluid(), energy), IFluidHandler.FluidAction.EXECUTE);
            }
            if ((float)this.fluidTank_main.getFluidAmount() <= (float)this.fluidTank_main.getCapacity() * 0.83333f || this.fluidTank_heat.getFluidAmount() == this.fluidTank_heat.getCapacity()) {
                this.scram(lv);
            }
        }
        if (this.isActive) {
            this.lamphelper.changeLampState(LampStates.GREEN);
        } else if (this.isSCRAMed) {
            this.lamphelper.changeLampState(LampStates.RED);
        } else {
            this.lamphelper.changeLampState(LampStates.YELLOW);
        }
        this.lamphelper.lampSyncer();
    }

    private void decreaseFuel(int index) {
        boolean changed = ItemStackUtil.damageItemInSlot(this.itemHandler, index, 1, () -> new ItemStack((ItemLike)ChemiItems.DEPLETED_FUEL_ROD.get()));
        if (changed) {
            this.dirty = true;
        }
    }

    private void scram(@Nonnull Level lv) {
        this.isSCRAMed = true;
        this.isActive = false;
        lv.m_5594_(null, this.f_58858_, SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 1.1f);
    }

    private void scramRecover() {
        this.isSCRAMed = false;
        this.dirty = true;
    }

    public void onSignalChanged(boolean poweredNow) {
        if (poweredNow && !this.wasPowered) {
            this.scramRecover();
        }
        this.wasPowered = poweredNow;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTankMain() {
        return this.fluidTank_main;
    }

    public FluidTank getFluidTankHeat() {
        return this.fluidTank_heat;
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.fluidTank_main.setFluid(fluid1);
        this.fluidTank_heat.setFluid(fluid2);
    }

    @Override
    public LampStates getLampStates() {
        return this.lamphelper.getLampStates();
    }

    @Override
    public void receivePacket(LampStates states) {
        this.lamphelper.receivePacket(states);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.waterTankLazyOptional.invalidate();
    }

    private class ReactorSlotState {
        private ReactorSlot slot = ReactorSlot.EMPTY;
        private int amplify = 1;
        private ReactorRecipe recipe = null;

        public void recalc(IItemHandler handler, int slotnum, Level lv) {
            int score = 0;
            this.slot = this.getSlotState(handler.getStackInSlot(slotnum));
            for (int rel : this.relatives(slotnum)) {
                ItemStack stackrel = handler.getStackInSlot(rel);
                if (this.getSlotState(stackrel) != ReactorSlot.FUEL) continue;
                ++score;
            }
            if (this.slot == ReactorSlot.RECIPE) {
                SimpleContainer container = new SimpleContainer(1);
                container.m_6836_(0, handler.getStackInSlot(slotnum));
                this.recipe = lv.m_7465_().m_44015_((RecipeType)ModRecipes.REACTOR_TYPE.get(), (Container)container, lv).orElse(null);
            } else {
                this.recipe = null;
            }
            this.amplify = score;
        }

        public ReactorSlot getSlotType() {
            return this.slot;
        }

        public int getAmplify() {
            return this.amplify;
        }

        @Nullable
        public ReactorRecipe getRecipe() {
            return this.recipe;
        }

        private Set<Integer> relatives(int slot) {
            if (slot == 0) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(1), Integer.valueOf(3)));
            }
            if (slot == 1) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4)));
            }
            if (slot == 2) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(1), Integer.valueOf(5)));
            }
            if (slot == 3) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(6)));
            }
            if (slot == 4) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7)));
            }
            if (slot == 5) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)));
            }
            if (slot == 6) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(3), Integer.valueOf(7)));
            }
            if (slot == 7) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8)));
            }
            if (slot == 8) {
                return new HashSet<Integer>(Set.of(Integer.valueOf(5), Integer.valueOf(7)));
            }
            throw new IndexOutOfBoundsException();
        }

        private ReactorSlot getSlotState(ItemStack stack) {
            if (stack.m_41619_()) {
                return ReactorSlot.EMPTY;
            }
            if (stack.m_41720_() == ChemiItems.URANIUM_FUEL_ROD.get()) {
                return ReactorSlot.FUEL;
            }
            return ReactorSlot.RECIPE;
        }
    }

    private static enum ReactorSlot {
        EMPTY,
        FUEL,
        RECIPE;

    }
}

