/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.lamp.ILampController;
import kandango.reagenica.block.entity.lamp.LampControllerHelper;
import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.packet.ISingleTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncFluidPacket;
import kandango.reagenica.screen.TankMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public abstract class SimpleTankBlockEntity
extends BlockEntity
implements MenuProvider,
ISingleTankBlock,
ITickableBlockEntity,
ILampController {
    protected final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            SimpleTankBlockEntity.this.m_6596_();
            SimpleTankBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return slot == 0;
        }
    };
    protected final FluidTank fluidTank = new FluidTank(this.tankSize()){

        protected void onContentsChanged() {
            SimpleTankBlockEntity.this.m_6596_();
            SimpleTankBlockEntity.this.syncFluidToClient();
        }
    };
    private boolean dirty = true;
    private final LampControllerHelper<SimpleTankBlockEntity> lamphelper = new LampControllerHelper<SimpleTankBlockEntity>(this);
    private final LazyOptional<IFluidHandler> fluidTankLazyOptional = LazyOptional.of(() -> this.fluidTank);

    public SimpleTankBlockEntity(BlockEntityType<? extends SimpleTankBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTank.readFromNBT(tag.m_128469_("Tank"));
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        CompoundTag fluidTag = new CompoundTag();
        this.fluidTank.writeToNBT(fluidTag);
        tag.m_128365_("Tank", (Tag)fluidTag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidTankLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new TankMenu(id, inv, this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncFluidPacket(this.f_58858_, this.fluidTank.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        boolean dirtyflag = false;
        if (this.dirty) {
            if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
                boolean out = FluidItemConverter.draintoItem(this.itemHandler, 0, 1, this.fluidTank);
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 0, 1, this.fluidTank);
                dirtyflag |= in || out;
            }
            int max = this.fluidTank.getCapacity();
            int amount = this.fluidTank.getFluidAmount();
            if (amount == 0) {
                this.lamphelper.changeLampState(LampStates.YELLOW);
            } else if ((float)amount >= (float)max * 0.98f) {
                this.lamphelper.changeLampState(LampStates.RED);
            } else {
                this.lamphelper.changeLampState(LampStates.GREEN);
            }
        }
        this.dirty = dirtyflag;
        this.lamphelper.lampSyncer();
    }

    @Override
    public void receivePacket(FluidStack fluid) {
        this.getFluidTank().setFluid(fluid);
    }

    @Override
    public LampStates getLampStates() {
        return this.lamphelper.getLampStates();
    }

    @Override
    public void receivePacket(LampStates states) {
        this.lamphelper.receivePacket(states);
    }

    protected abstract int tankSize();

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidTankLazyOptional.invalidate();
    }
}

