/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.StallTradingRecipe;
import kandango.reagenica.screen.TradingStallMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class TradingStallBlockEntity
extends BlockEntity
implements MenuProvider {
    private final int SLOTCOUNT = 27;
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TradingStallBlockEntity.this.m_6596_();
        }
    };

    public TradingStallBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRADING_STALL.get(), pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return LazyOptional.empty();
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_6596_() {
        super.m_6596_();
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            lv.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.trading_stall");
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new TradingStallMenu(id, inv, this);
    }

    public long trade(Villager villager, Level lv) {
        int account = 0;
        ArrayList validmerches = new ArrayList();
        Random rand = new Random();
        int i = 0;
        while (i < 27) {
            int index = i++;
            ItemStack item = this.itemHandler.getStackInSlot(index);
            SimpleContainer container = new SimpleContainer(1);
            container.m_6836_(0, item);
            Optional mayberecipe = lv.m_7465_().m_44015_((RecipeType)ModRecipes.STALL_TRADING_TYPE.get(), (Container)container, lv);
            mayberecipe.ifPresent(recipe -> validmerches.add(new RecipeSlot((StallTradingRecipe)recipe, index)));
        }
        for (RecipeSlot ri : validmerches) {
            StallTradingRecipe recipe2 = ri.recipe();
            int index = ri.index();
            ItemStack merchandise = recipe2.getMerchandise();
            ItemStack priceitem = recipe2.getPrice();
            int price = priceitem.m_41613_();
            ItemStack merchstack = this.itemHandler.getStackInSlot(index);
            if (account + price + rand.nextInt(20) > 10) continue;
            this.doTrade(index, priceitem, merchandise.m_41613_(), merchstack.m_41613_());
            account += price;
            if (!(lv instanceof ServerLevel)) continue;
            ServerLevel slev = (ServerLevel)lv;
            slev.m_8767_((ParticleOptions)ParticleTypes.f_123748_, villager.m_20185_() + 0.5, villager.m_20186_() + 1.5, villager.m_20189_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
        }
        if (account == 0) {
            return 200L + (long)rand.nextInt(1200);
        }
        if (account <= 4) {
            return 2400L + (long)rand.nextInt(1200);
        }
        return 3600L + (long)rand.nextInt(1200);
    }

    private void doTrade(int slot, ItemStack price, int unit, int count) {
        int multiplier = count / unit;
        if (multiplier <= 0) {
            throw new IllegalArgumentException("merchandise count is less than its unit");
        }
        int perunit = price.m_41613_();
        ItemStack resultItemstack = price.m_41777_();
        resultItemstack.m_41764_(perunit * multiplier);
        this.itemHandler.setStackInSlot(slot, resultItemstack);
    }

    private record RecipeSlot(StallTradingRecipe recipe, int index) {
    }
}

