/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.fluidhandlers.DrainOnlyFluidHandler;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.screen.AirSeparatorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class AirSeparatorBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider,
IDualTankBlock {
    public static final int PRODUCTION_UNIT = 20;
    private boolean dirty = true;
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            AirSeparatorBlockEntity.this.m_6596_();
            AirSeparatorBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (slot == 0) {
                return true;
            }
            return slot % 2 == 1;
        }
    };
    private final FluidTank oxygenTank = new FluidTank(10000){

        protected void onContentsChanged() {
            AirSeparatorBlockEntity.this.m_6596_();
            AirSeparatorBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank nitrogenTank = new FluidTank(10000){

        protected void onContentsChanged() {
            AirSeparatorBlockEntity.this.m_6596_();
            AirSeparatorBlockEntity.this.syncFluidToClient();
        }
    };
    private int progress = 0;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).anyfluidOutputslot(1).anyfluidOutputslot(3).build());
    private final LazyOptional<IFluidHandler> oxygenHandlerLazyOptional = LazyOptional.of(() -> new DrainOnlyFluidHandler(this.oxygenTank));
    private final LazyOptional<IFluidHandler> nitrogenHandlerLazyOptional = LazyOptional.of(() -> new DrainOnlyFluidHandler(this.nitrogenTank));

    public FluidStack getOxygen() {
        return this.oxygenTank.getFluid();
    }

    public FluidStack getNitrogen() {
        return this.nitrogenTank.getFluid();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public AirSeparatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.AIR_SEPARATOR.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.nitrogenTank.readFromNBT(tag.m_128469_("NitrogenTank"));
        this.oxygenTank.readFromNBT(tag.m_128469_("OxygenTank"));
        this.progress = tag.m_128451_("Progress");
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        FluidStackUtil.saveFluid(tag, "NitrogenTank", this.nitrogenTank);
        FluidStackUtil.saveFluid(tag, "OxygenTank", this.oxygenTank);
        tag.m_128405_("Progress", this.progress);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == Direction.UP) {
                return this.oxygenHandlerLazyOptional.cast();
            }
            return this.nitrogenHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.nitrogenTank.getFluid().copy(), this.oxygenTank.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        ItemStack filterItem;
        int speed;
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        boolean flag = false;
        if (this.dirty) {
            if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
                flag |= FluidItemConverter.draintoItem(this.itemHandler, 1, 2, this.oxygenTank);
            }
            if (!this.itemHandler.getStackInSlot(3).m_41619_()) {
                flag |= FluidItemConverter.draintoItem(this.itemHandler, 3, 4, this.nitrogenTank);
            }
        }
        if ((speed = this.filterSpeed(filterItem = this.itemHandler.getStackInSlot(0))) != 0 && this.insertable()) {
            int energyConsumption = 10 * speed;
            if (this.getEnergy() > energyConsumption) {
                this.consumeEnergy(energyConsumption);
                this.progress += speed;
                if (this.progress > 600) {
                    this.progress = 0;
                    ItemStackUtil.damageItemInSlot(this.itemHandler, 0, 1, () -> ItemStack.f_41583_);
                    this.nitrogenTank.fill(new FluidStack(ChemiFluids.NITROGEN.getFluid(), 80), IFluidHandler.FluidAction.EXECUTE);
                    this.oxygenTank.fill(new FluidStack(ChemiFluids.OXYGEN.getFluid(), 20), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        this.dirty = flag;
    }

    private int filterSpeed(ItemStack filter) {
        if (filter.m_150930_((Item)ChemiItems.COPPER_FILTER.get())) {
            return 1;
        }
        if (filter.m_150930_((Item)ChemiItems.SILVER_FILTER.get())) {
            return 3;
        }
        if (filter.m_150930_((Item)ChemiItems.PLATINUM_FILTER.get())) {
            return 6;
        }
        return 0;
    }

    private boolean insertable() {
        return this.nitrogenTank.getSpace() > 80 && this.oxygenTank.getSpace() > 20;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new AirSeparatorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.air_separator");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 1000, 400);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.oxygenHandlerLazyOptional.invalidate();
        this.nitrogenHandlerLazyOptional.invalidate();
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.nitrogenTank.setFluid(fluid1);
        this.oxygenTank.setFluid(fluid2);
    }
}

