/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.recipes.CrusherRecipe;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.screen.CrusherMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CrusherBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            CrusherBlockEntity.this.m_6596_();
            CrusherBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot == 0) {
                return true;
            }
            if (slot == 1) {
                return false;
            }
            return false;
        }
    };
    private int progress = 0;
    private boolean dirty = true;
    private Optional<CrusherRecipe> cachedRecipe;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).outputslot(1).build());

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public CrusherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.CRUSHER.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.progress = tag.m_128451_("Progress");
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
        super.m_183515_(tag);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new CrusherMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.crusher");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        ItemStack outslot;
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        boolean isLit = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            ItemStack output;
            SimpleContainer container = new SimpleContainer(1);
            container.m_6836_(0, this.itemHandler.getStackInSlot(0));
            this.cachedRecipe = lv.m_7465_().m_44015_((RecipeType)ModRecipes.CRUSHER_TYPE.get(), (Container)container, lv);
            if (this.cachedRecipe.isPresent() && !ItemStackUtil.canAddStack(outslot = this.itemHandler.getStackInSlot(1), output = this.cachedRecipe.orElseThrow().getOutput())) {
                this.cachedRecipe = Optional.empty();
            }
        }
        if (this.cachedRecipe.isPresent() && this.getEnergy() >= 16) {
            ++this.progress;
            isLit = true;
            this.consumeEnergy(16);
            if (this.progress >= 200) {
                ItemStack result;
                CrusherRecipe recipe = this.cachedRecipe.orElseThrow();
                outslot = this.itemHandler.getStackInSlot(1);
                if (!ItemStackUtil.canAddStack(outslot, result = recipe.getOutput())) {
                    ChemistryMod.LOGGER.error("Could not merge stack!");
                    return;
                }
                this.itemHandler.setStackInSlot(1, ItemStackUtil.addStack(outslot, result));
                this.itemHandler.getStackInSlot(0).m_41774_(1);
                this.progress = 0;
                dirtyflag = true;
            }
        }
        this.dirty = dirtyflag;
        LitUtil.setLit(isLit, lv, this.f_58858_);
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 200, 200);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }
}

