/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.recipes.DissolverRecipe;
import kandango.reagenica.screen.DissolverMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class DissolverBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider,
IDualTankBlock {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            DissolverBlockEntity.this.m_6596_();
            DissolverBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return slot % 2 == 0;
        }
    };
    private final FluidTank inputFluid = new FluidTank(8000){

        protected void onContentsChanged() {
            DissolverBlockEntity.this.m_6596_();
            DissolverBlockEntity.this.dirty = true;
            DissolverBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank outputFluid = new FluidTank(8000){

        protected void onContentsChanged() {
            DissolverBlockEntity.this.m_6596_();
            DissolverBlockEntity.this.dirty = true;
            DissolverBlockEntity.this.syncFluidToClient();
        }
    };
    private int progress = 0;
    private boolean dirty = true;
    private Optional<DissolverRecipe> cachedRecipe = Optional.empty();
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).outputslot(1).anyfluidInputslot(2).anyfluidOutputslot(4).build());
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.inputFluid, this.outputFluid));

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public DissolverBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.DISSOLVER.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.inputFluid.readFromNBT(tag.m_128469_("InputTank"));
        this.outputFluid.readFromNBT(tag.m_128469_("OutputTank"));
        this.progress = tag.m_128451_("Progress");
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.inputFluid.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.outputFluid.writeToNBT(fluidTag);
        tag.m_128365_("OutputTank", (Tag)fluidTag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
        super.m_183515_(tag);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
            return this.fluidHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getInputTank() {
        return this.inputFluid;
    }

    public FluidTank getOutputTank() {
        return this.outputFluid;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new DissolverMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.dissolver");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.inputFluid.getFluid().copy(), this.outputFluid.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        boolean working = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            if (!this.itemHandler.getStackInSlot(2).m_41619_()) {
                boolean out = FluidItemConverter.draintoItem(this.itemHandler, 2, 3, this.inputFluid);
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 2, 3, this.inputFluid);
                boolean bl = dirtyflag = in || out;
            }
            if (!this.itemHandler.getStackInSlot(4).m_41619_()) {
                dirtyflag = FluidItemConverter.draintoItem(this.itemHandler, 4, 5, this.outputFluid);
            }
            this.cachedRecipe = DissolverRecipe.getRecipe(this.inputFluid.getFluid(), this.itemHandler.getStackInSlot(0), lv);
        }
        this.dirty = dirtyflag;
        if (this.cachedRecipe.isPresent() && this.getEnergy() >= 5) {
            DissolverRecipe recipe = this.cachedRecipe.orElseThrow();
            FluidStack fluidin = recipe.getFluidIn();
            FluidStack fluidout = recipe.getFluidOut();
            ItemStack itemout = recipe.getOutputItem();
            if (FluidStackUtil.canFullyInsertToTank(fluidout, this.outputFluid) && ItemStackUtil.canAddStack(this.itemHandler.getStackInSlot(1), itemout)) {
                working = true;
                ++this.progress;
                this.consumeEnergy(5);
                if (this.progress >= 200) {
                    this.inputFluid.drain(fluidin.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    this.itemHandler.extractItem(0, 1, false);
                    this.outputFluid.fill(fluidout, IFluidHandler.FluidAction.EXECUTE);
                    ItemStackUtil.addStackToSlot(this.itemHandler, 1, itemout);
                    this.progress = 0;
                }
            }
        }
        LitUtil.setLit(working, lv, this.f_58858_);
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(6000, 200, 200);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.inputFluid.setFluid(fluid1);
        this.outputFluid.setFluid(fluid2);
    }
}

