/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nullable;
import kandango.reagenica.block.entity.electrical.ElectricMachineAbstract;
import kandango.reagenica.block.entity.electrical.Handlers.ConsumerEnergyHandler;
import kandango.reagenica.network.CableNetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class ElectricConsumerAbstract
extends ElectricMachineAbstract {
    private final LazyOptional<IEnergyStorage> energyInLazyOptional = LazyOptional.of(() -> new ConsumerEnergyHandler(this.energyStorage));

    public ElectricConsumerAbstract(BlockEntityType<? extends ElectricConsumerAbstract> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricMachineAbstract>)type, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyInLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyInLazyOptional.invalidate();
    }

    public void onLoad() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            CableNetworkManager.requestUpdate(slv, this.f_58858_);
        }
        super.onLoad();
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            CableNetworkManager.requestUpdate(slv, this.f_58858_);
        }
        super.m_7651_();
    }
}

