/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.electrical.ElectricCableAbstract;
import kandango.reagenica.block.entity.electrical.ElectricMachineAbstract;
import kandango.reagenica.block.entity.electrical.Handlers.GeneratorEnergyHandler;
import kandango.reagenica.network.CableNetworkManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class ElectricGeneratorAbstract
extends ElectricMachineAbstract {
    private Map<BlockPos, ElectroTerminal> customerCostMap = new HashMap<BlockPos, ElectroTerminal>();
    private boolean networkChanged = true;
    private final LazyOptional<IEnergyStorage> energyOutLazyOptional = LazyOptional.of(() -> new GeneratorEnergyHandler(this.energyStorage));

    public void notifyChange() {
        this.networkChanged = true;
    }

    public ElectricGeneratorAbstract(BlockEntityType<? extends ElectricGeneratorAbstract> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricMachineAbstract>)type, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOutLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOutLazyOptional.invalidate();
    }

    @Override
    public void serverTick() {
    }

    public void onLoad() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            CableNetworkManager.requestUpdate(slv, this.f_58858_);
        }
        super.onLoad();
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            CableNetworkManager.requestUpdate(slv, this.f_58858_);
        }
        super.m_7651_();
    }

    protected void provideEnergy() {
        Level lv = this.m_58904_();
        if (lv == null) {
            return;
        }
        if (this.networkChanged) {
            this.refleshCustomers();
        }
        ArrayList customers = new ArrayList();
        for (Map.Entry<BlockPos, ElectroTerminal> term : this.customerCostMap.entrySet()) {
            BlockPos customerpos = term.getKey();
            if (!lv.m_46749_(customerpos)) continue;
            Object customer = lv.m_7702_(customerpos);
            if (customer == null) {
                this.networkChanged = true;
                continue;
            }
            customer.getCapability(ForgeCapabilities.ENERGY, term.getValue().side).filter(s -> s.canReceive()).ifPresent(s -> customers.add(new StorageAndCost((IEnergyStorage)s, ((ElectroTerminal)term.getValue()).cost)));
        }
        int maxExtract = this.energyStorage.extractEnergy(Integer.MAX_VALUE, true);
        int demand = customers.stream().mapToInt(s -> ElectricGeneratorAbstract.demand(s, this.getOfferUnit())).sum();
        if (demand > 0 && maxExtract >= demand) {
            for (Object customer : customers) {
                IEnergyStorage storage = customer.storage;
                double cost = customer.cost;
                int inserted = storage.receiveEnergy((int)((double)ElectricGeneratorAbstract.demand((StorageAndCost)customer, this.getOfferUnit()) - cost), false);
                if (inserted == 0) continue;
                this.energyStorage.extractEnergy(inserted + (int)(0.91 + cost), false);
            }
        }
    }

    private static int demand(StorageAndCost str, int offer) {
        IEnergyStorage storage = str.storage;
        int inputtable = storage.receiveEnergy(offer, true);
        if ((double)inputtable >= (double)offer - str.cost) {
            return offer;
        }
        if (inputtable >= offer / 2) {
            return inputtable;
        }
        return 0;
    }

    private void refleshCustomers() {
        this.networkChanged = false;
        this.customerCostMap.clear();
        this.reofferEnergy();
    }

    protected int getOfferUnit() {
        return 40;
    }

    public void reofferEnergy() {
        BlockPos pos = this.m_58899_();
        Level level = this.m_58904_();
        if (level == null) {
            this.networkChanged = true;
            return;
        }
        this.traceCable(pos, level);
    }

    private void traceCable(BlockPos startpos, @Nonnull Level lv) {
        PriorityQueue<Node> queue = new PriorityQueue<Node>(Comparator.comparingDouble(node -> node.cost()));
        HashMap<BlockPos, Double> costMap = new HashMap<BlockPos, Double>();
        for (Direction dir : Direction.values()) {
            Direction inputtingSide;
            if (!this.getCapability(ForgeCapabilities.ENERGY, dir).filter(s -> s.canExtract()).isPresent()) continue;
            BlockPos rel = startpos.m_121945_(dir);
            BlockEntity be = lv.m_7702_(rel);
            if (be instanceof ElectricCableAbstract) {
                queue.add(new Node(rel, 0.1));
                costMap.put(rel, 0.1);
                continue;
            }
            if (be == null || !be.getCapability(ForgeCapabilities.ENERGY, inputtingSide = dir.m_122424_()).filter(str -> str.canReceive()).isPresent()) continue;
            costMap.put(rel, 0.1);
            this.customerCostMap.put(rel, new ElectroTerminal(0.1, inputtingSide));
        }
        costMap.put(startpos, 0.0);
        int watchdog = 0;
        while (!queue.isEmpty()) {
            if (++watchdog > 1000) {
                ChemistryMod.LOGGER.warn("Cable tracing exceeded safety limit (1000). Origin: {}", (Object)startpos.m_123344_());
                return;
            }
            Node node2 = queue.poll();
            if ((Double)costMap.get(node2.pos) < node2.cost) continue;
            for (Direction dir : Direction.values()) {
                Double previous;
                Direction inputtingSide;
                BlockPos neighbor = node2.pos.m_121945_(dir);
                BlockEntity be = lv.m_7702_(neighbor);
                if (be instanceof ElectricCableAbstract) {
                    ElectricCableAbstract cable = (ElectricCableAbstract)be;
                    double resistance = cable.getResistance();
                    double newcost = node2.cost + resistance;
                    if (!(newcost < costMap.getOrDefault(neighbor, Double.POSITIVE_INFINITY))) continue;
                    costMap.put(neighbor, newcost);
                    queue.add(new Node(neighbor, newcost));
                    continue;
                }
                if (be == null || !be.getCapability(ForgeCapabilities.ENERGY, inputtingSide = dir.m_122424_()).filter(str -> str.canReceive()).isPresent() || !((previous = costMap.getOrDefault(neighbor, Double.POSITIVE_INFINITY)) > node2.cost)) continue;
                costMap.put(neighbor, node2.cost);
                this.customerCostMap.put(neighbor, new ElectroTerminal(node2.cost, inputtingSide));
            }
        }
    }

    public void tellCustomers(CommandSourceStack source) {
        source.m_243053_((Component)Component.m_237113_((String)"This Block has customers below:"));
        this.customerCostMap.entrySet().stream().forEach(entry -> source.m_243053_((Component)Component.m_237113_((String)(((BlockPos)entry.getKey()).m_123344_() + " costs " + ((ElectroTerminal)entry.getValue()).cost)).m_130940_(ChatFormatting.AQUA)));
    }

    private record ElectroTerminal(double cost, Direction side) {
    }

    private record StorageAndCost(IEnergyStorage storage, double cost) {
    }

    private record Node(BlockPos pos, double cost) {
    }
}

