/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.Set;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.electrical.ElectricAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ElectricMachineAbstract
extends ElectricAbstract
implements ITickableBlockEntity {
    public Set<BlockPos> connectedCables;
    protected final ElectricStorage energyStorage = this.energyStorageProvider();

    public ElectricMachineAbstract(BlockEntityType<? extends ElectricMachineAbstract> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected abstract ElectricStorage energyStorageProvider();

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergy(int e) {
        this.energyStorage.setEnergy(e);
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int consumeEnergy(int amount) {
        return this.energyStorage.extractEnergy(amount, false);
    }

    public void giveEnergy(int amount) {
        this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() + amount);
    }

    public int getEnergySpace() {
        return this.getMaxEnergy() - this.getEnergy();
    }

    public int getMaxLegalExtract() {
        return this.energyStorage.extractEnergy(this.getEnergy(), true);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
    }

    public ElectricStorage getElectricStorage(int index) {
        return this.energyStorage;
    }

    public void reviveCaps() {
        super.reviveCaps();
    }
}

