/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.ChemiTags;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.recipes.ElectroLysisRecipe;
import kandango.reagenica.screen.ElectroLysisMenu;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class ElectroLysisBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider,
IDualTankBlock {
    private final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            ElectroLysisBlockEntity.this.m_6596_();
            ElectroLysisBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot <= 1) {
                return true;
            }
            if (slot == 2) {
                return false;
            }
            return slot % 2 != 0;
        }
    };
    public static final int ANODE_ELECTRODE_SLOT = 0;
    public static final int CATHODE_ELECTRODE_SLOT = 1;
    public static final int ANODE_OUTPUT_SLOT = 2;
    public static final int CATHODE_OUTPUT_SLOT = 11;
    public static final int ANODE_GAS_TESTTUBE_SLOT = 3;
    public static final int CATHODE_GAS_TESTTUBE_SLOT = 5;
    public static final int OUTPUT_FLUID_SLOT = 7;
    public static final int INPUT_FLUID_SLOT = 9;
    private final FluidTank inputFluid = new FluidTank(8000){

        protected void onContentsChanged() {
            ElectroLysisBlockEntity.this.m_6596_();
            ElectroLysisBlockEntity.this.dirty = true;
            ElectroLysisBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank outputFluid = new FluidTank(4000){

        protected void onContentsChanged() {
            ElectroLysisBlockEntity.this.m_6596_();
            ElectroLysisBlockEntity.this.dirty = true;
            ElectroLysisBlockEntity.this.syncFluidToClient();
        }
    };
    private int progress = 0;
    private boolean dirty = true;
    private ElectroLysisRecipe cachedRecipe = null;
    private boolean isUsingEnergy = false;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).customInputRule(SlotPriorityRule.single(item -> item.m_150930_((Item)ChemiItems.TESTTUBE.get()), 3)).customInputRule(SlotPriorityRule.single(item -> item.m_150930_((Item)ChemiItems.TESTTUBE.get()), 5)).customInputRule(SlotPriorityRule.single(item -> item.m_204117_(ChemiTags.Items.ELECTRODES), 0)).customInputRule(SlotPriorityRule.single(item -> item.m_204117_(ChemiTags.Items.ELECTRODES), 1)).anyfluidInputslot(9).anyfluidOutputslot(7).outputslot(11, 2, 4, 6).build());
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.inputFluid, this.outputFluid));

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public boolean isUsingEnergy() {
        return this.isUsingEnergy;
    }

    public void setUsingEnergy(boolean p) {
        this.isUsingEnergy = p;
    }

    public ElectroLysisBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.ELECTROLYSIS_DEVICE.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.inputFluid.readFromNBT(tag.m_128469_("InputTank"));
        this.outputFluid.readFromNBT(tag.m_128469_("OutputTank"));
        this.progress = tag.m_128451_("Progress");
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.inputFluid.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.outputFluid.writeToNBT(fluidTag);
        tag.m_128365_("OutputTank", (Tag)fluidTag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
        super.m_183515_(tag);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
            return this.fluidHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getInputTank() {
        return this.inputFluid;
    }

    public FluidTank getOutputTank() {
        return this.outputFluid;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ElectroLysisMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.electrolysis_device");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.inputFluid.getFluid().copy(), this.outputFluid.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            boolean out;
            if (!this.itemHandler.getStackInSlot(7).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 7, this.outputFluid);
                dirtyflag |= out;
            }
            if (!this.itemHandler.getStackInSlot(9).m_41619_()) {
                out = FluidItemConverter.draintoItem(this.itemHandler, 9, this.inputFluid);
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 9, this.inputFluid);
                dirtyflag = in || out;
            }
            this.cachedRecipe = ElectroLysisRecipe.getRecipe(this.inputFluid.getFluid(), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(0), lv).filter(r -> this.canInsert((ElectroLysisRecipe)r)).orElse(null);
        }
        if (this.cachedRecipe != null && this.getEnergy() >= 20) {
            ItemStack anoderes = this.cachedRecipe.getOutputP();
            ItemStack cathoderes = this.cachedRecipe.getOutputN();
            FluidStack outfluid = this.cachedRecipe.getFluidOut();
            ItemStack anodegas = this.cachedRecipe.getOutputGasP();
            ItemStack cathodegas = this.cachedRecipe.getOutputGasN();
            FluidStack influid = this.cachedRecipe.getFluidIn();
            if (this.canInsert(this.cachedRecipe)) {
                ++this.progress;
                this.consumeEnergy(20);
                if (this.progress >= 400) {
                    boolean res;
                    this.progress = 0;
                    this.inputFluid.drain(influid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    ItemStackUtil.addStackToSlot(this.itemHandler, 2, anoderes);
                    ItemStackUtil.addStackToSlot(this.itemHandler, 11, cathoderes);
                    this.outputFluid.fill(outfluid, IFluidHandler.FluidAction.EXECUTE);
                    if (!anodegas.m_41619_() && this.itemHandler.getStackInSlot(3).m_41720_() == ChemiItems.TESTTUBE.get() && (res = ItemStackUtil.addStackToSlotifPossible(this.itemHandler, 4, anodegas))) {
                        this.itemHandler.getStackInSlot(3).m_41774_(1);
                    }
                    if (!cathodegas.m_41619_() && this.itemHandler.getStackInSlot(5).m_41720_() == ChemiItems.TESTTUBE.get() && (res = ItemStackUtil.addStackToSlotifPossible(this.itemHandler, 6, cathodegas))) {
                        this.itemHandler.getStackInSlot(5).m_41774_(1);
                    }
                    if (this.cachedRecipe.anodeMelts()) {
                        ItemStackUtil.damageItemInSlot(this.itemHandler, 0, 10, () -> ItemStack.f_41583_);
                    } else {
                        ItemStackUtil.damageItemInSlot(this.itemHandler, 0, 1, () -> ItemStack.f_41583_);
                    }
                    ItemStackUtil.damageItemInSlot(this.itemHandler, 1, 1, () -> ItemStack.f_41583_);
                    dirtyflag = true;
                }
            }
        }
        this.dirty = dirtyflag;
    }

    private boolean canInsert(ElectroLysisRecipe recipe) {
        ItemStack anode = recipe.getOutputP();
        ItemStack cathode = recipe.getOutputN();
        FluidStack fluid = recipe.getFluidOut();
        ItemStack anodeslot = this.itemHandler.getStackInSlot(2);
        ItemStack cathodeslot = this.itemHandler.getStackInSlot(11);
        return !(!anodeslot.m_41619_() && !ItemStackUtil.canAddStack(anodeslot, anode) || !cathodeslot.m_41619_() && !ItemStackUtil.canAddStack(cathodeslot, cathode) || !FluidStackUtil.canFullyInsertToTank(fluid, this.outputFluid));
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 200, 200);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.inputFluid.setFluid(fluid1);
        this.outputFluid.setFluid(fluid2);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }
}

