/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricGeneratorAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.block.fluid.ChemiFluidBurnMap;
import kandango.reagenica.packet.ISingleTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncFluidPacket;
import kandango.reagenica.screen.FluidFuelGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class FluidFuelGeneratorBlockEntity
extends ElectricGeneratorAbstract
implements MenuProvider,
ISingleTankBlock {
    private boolean dirty = true;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            FluidFuelGeneratorBlockEntity.this.dirty = true;
            FluidFuelGeneratorBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return true;
        }
    };
    private final FluidTank fuelTank = new FluidTank(8000){

        protected void onContentsChanged() {
            FluidFuelGeneratorBlockEntity.this.m_6596_();
            FluidFuelGeneratorBlockEntity.this.syncFluidToClient();
        }
    };
    private boolean isBurning;
    private int reservedEnergyTick;
    private int reservedEnergyrate;
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).outputslot(1).build());
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fuelTank);

    public FluidTank getFuelFluid() {
        return this.fuelTank;
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean p) {
        this.isBurning = p;
    }

    public FluidFuelGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricGeneratorAbstract>)((BlockEntityType)ModBlockEntities.GENERATOR_FLUID.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.fuelTank.readFromNBT(tag.m_128469_("FuelTank"));
        this.isBurning = tag.m_128471_("isBurning");
        this.reservedEnergyTick = tag.m_128451_("reservedEnergyTick");
        this.reservedEnergyrate = tag.m_128451_("ReservedEnergyRate");
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        FluidStackUtil.saveFluid(tag, "FuelTank", this.fuelTank);
        tag.m_128379_("isBurning", this.isBurning);
        tag.m_128405_("reservedEnergyTick", this.reservedEnergyTick);
        tag.m_128405_("ReservedEnergyRate", this.reservedEnergyrate);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncFluidPacket(this.f_58858_, this.fuelTank.getFluid().copy()));
        }
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty && !this.itemHandler.getStackInSlot(0).m_41619_()) {
            boolean out = FluidItemConverter.draintoItem(this.itemHandler, 0, 1, this.fuelTank);
            boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 0, 1, this.fuelTank);
            this.dirty |= in || out;
        }
        this.isBurning = false;
        if (this.reservedEnergyTick == 0 && this.fuelTank.getFluidAmount() >= 10) {
            ChemiFluidBurnMap.getBurnrate(this.fuelTank.getFluid().getFluid()).filter(r -> !this.energyStorage.isFull()).ifPresent(rate -> {
                this.reservedEnergyrate = rate.energyPerTick();
                this.reservedEnergyTick = rate.burnTick();
                this.fuelTank.drain(10, IFluidHandler.FluidAction.EXECUTE);
            });
        }
        if (this.reservedEnergyTick > 0) {
            --this.reservedEnergyTick;
            this.generateEnergy(this.reservedEnergyrate);
            this.isBurning = true;
        }
        LitUtil.setLit(this.isBurning, lv, this.f_58858_);
        this.provideEnergy();
    }

    private void generateEnergy(int amount) {
        if (this.energyStorage.receiveEnergy(amount, true) > 0) {
            this.energyStorage.receiveEnergy(amount, false);
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new FluidFuelGeneratorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.fluid_fuel_generator");
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 1000, 600);
    }

    @Override
    public void receivePacket(FluidStack fluid1) {
        this.fuelTank.setFluid(fluid1);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }
}

