/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricGeneratorAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.screen.FuelGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class FuelGeneratorBlockEntity
extends ElectricGeneratorAbstract
implements MenuProvider {
    private boolean dirty = true;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FuelGeneratorBlockEntity.this.m_6596_();
            FuelGeneratorBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return true;
        }
    };
    private int burnTimeRemaining = 0;
    private int maxburnTime = 0;
    private final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);

    public FuelGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricGeneratorAbstract>)((BlockEntityType)ModBlockEntities.GENERATOR_FUEL.get()), pos, state);
    }

    public int getBurnTime() {
        return this.burnTimeRemaining;
    }

    public int getMaxburntime() {
        return this.maxburnTime;
    }

    public void setBurnTime(int x) {
        this.burnTimeRemaining = x;
    }

    public void setMaxburntime(int x) {
        this.maxburnTime = x;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.burnTimeRemaining = tag.m_128451_("BurnTime");
        this.maxburnTime = tag.m_128451_("MaxBurnTime");
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("BurnTime", this.burnTimeRemaining);
        tag.m_128405_("MaxBurnTime", this.maxburnTime);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        boolean flag = false;
        if (this.burnTimeRemaining > 0) {
            --this.burnTimeRemaining;
            this.generateEnergy();
            if (this.burnTimeRemaining == 0) {
                flag = true;
            }
        } else if (this.dirty) {
            ItemStack fuelstack = this.itemHandler.getStackInSlot(0);
            int burn = ItemStackUtil.getFuelExceptforLava(fuelstack);
            if (burn > 0) {
                this.burnTimeRemaining = burn;
                this.maxburnTime = burn;
                fuelstack.m_41774_(1);
                LitUtil.setLit(true, lv, this.f_58858_);
            } else {
                LitUtil.setLit(false, lv, this.f_58858_);
            }
        }
        this.dirty = flag;
        this.provideEnergy();
    }

    private void generateEnergy() {
        if (this.energyStorage.receiveEnergy(8, true) > 0) {
            this.energyStorage.receiveEnergy(8, false);
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new FuelGeneratorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.fuel_generator");
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 1000, 400);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }
}

