/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.fluidsyncer.FluidSyncHelper;
import kandango.reagenica.block.entity.itemhandler.CommonChemiItemHandler;
import kandango.reagenica.block.entity.lamp.ILampController;
import kandango.reagenica.block.entity.lamp.LampControllerHelper;
import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.block.entity.util.LitUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.recipes.HeatFurnaceRecipe;
import kandango.reagenica.screen.HeatFurnaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class HeatFurnaceBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider,
IDualTankBlock,
ILampController {
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            HeatFurnaceBlockEntity.this.m_6596_();
            HeatFurnaceBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot == 0) {
                return true;
            }
            if (slot == 1) {
                return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
            }
            if (slot < 4) {
                return false;
            }
            return slot == 4 || slot == 6;
        }
    };
    private final FluidTank inputFluid = new FluidTank(8000){

        protected void onContentsChanged() {
            HeatFurnaceBlockEntity.this.m_6596_();
            HeatFurnaceBlockEntity.this.dirty = true;
        }
    };
    private final FluidTank outputFluid = new FluidTank(8000){

        protected void onContentsChanged() {
            HeatFurnaceBlockEntity.this.m_6596_();
            HeatFurnaceBlockEntity.this.dirty = true;
        }
    };
    private final FluidSyncHelper fluidSyncHelper = new FluidSyncHelper(this.f_58858_, FluidSyncHelper.SyncType.ALWAYS, this.inputFluid, this.outputFluid);
    private int progress = 0;
    private int fuel = 0;
    private int fuelmax = 1600;
    private boolean dirty = true;
    private HeatFurnaceRecipe cachedRecipe = null;
    private boolean isUsingEnergy = false;
    private final LampControllerHelper<HeatFurnaceBlockEntity> lamphelper = new LampControllerHelper<HeatFurnaceBlockEntity>(this);
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> CommonChemiItemHandler.Builder.of(this.itemHandler).fuelslot(1).outputslot(2, 3).anyfluidInputslot(4).anyfluidOutputslot(6).build());
    private final LazyOptional<IFluidHandler> fluidTanksLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.inputFluid, this.outputFluid));

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int p) {
        this.fuel = p;
    }

    public int getFuelMax() {
        return this.fuelmax;
    }

    public void setFuelMax(int p) {
        this.fuelmax = p;
    }

    public boolean isUsingEnergy() {
        return this.isUsingEnergy;
    }

    public void setUsingEnergy(boolean p) {
        this.isUsingEnergy = p;
    }

    public HeatFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.HEAT_FURNACE.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.inputFluid.readFromNBT(tag.m_128469_("InputTank"));
        this.outputFluid.readFromNBT(tag.m_128469_("OutputTank"));
        this.progress = tag.m_128451_("Progress");
        this.fuel = tag.m_128451_("Fuel");
        this.fuelmax = tag.m_128451_("FuelMax");
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag fluidTag = new CompoundTag();
        this.inputFluid.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.outputFluid.writeToNBT(fluidTag);
        tag.m_128365_("OutputTank", (Tag)fluidTag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("Fuel", this.fuel);
        tag.m_128405_("FuelMax", this.fuelmax);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidTanksLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getInputTank() {
        return this.inputFluid;
    }

    public FluidTank getOutputTank() {
        return this.outputFluid;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new HeatFurnaceMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.heat_furnace");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        boolean dirtyflag = false;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            ItemStack fuelstack;
            int burn;
            SimpleContainer container = new SimpleContainer(5);
            container.m_6836_(0, this.itemHandler.getStackInSlot(0));
            this.cachedRecipe = HeatFurnaceRecipe.getRecipe(this.inputFluid.getFluid(), this.itemHandler.getStackInSlot(0), lv).filter(this::canInsert).orElse(null);
            if (this.fuel == 0 && this.cachedRecipe != null && (burn = ForgeHooks.getBurnTime((ItemStack)(fuelstack = this.itemHandler.getStackInSlot(1)), (RecipeType)RecipeType.f_44108_)) > 0) {
                this.fuel = burn;
                this.fuelmax = burn;
                this.itemHandler.getStackInSlot(1).m_41774_(1);
            }
            if (!this.itemHandler.getStackInSlot(4).m_41619_()) {
                boolean out = FluidItemConverter.draintoItem(this.itemHandler, 4, 5, this.inputFluid);
                boolean in = FluidItemConverter.drainfromItem(this.itemHandler, 4, 5, this.inputFluid);
                boolean bl = dirtyflag = in || out;
            }
            if (!this.itemHandler.getStackInSlot(6).m_41619_()) {
                dirtyflag = FluidItemConverter.draintoItem(this.itemHandler, 6, 7, this.outputFluid);
            }
        }
        this.dirty = dirtyflag;
        this.isUsingEnergy = false;
        boolean isLit = false;
        if (this.fuel > 0 || this.getEnergy() > 0) {
            if (this.cachedRecipe != null) {
                this.lamphelper.changeLampState(LampStates.GREEN);
                isLit = true;
                ItemStack output = this.cachedRecipe.getOutput();
                ItemStack byproduct = this.cachedRecipe.getByproduct();
                FluidStack fluidin = this.cachedRecipe.getFluidIn();
                FluidStack fluidOut = this.cachedRecipe.getFluidOut();
                if (this.canInsert(this.cachedRecipe)) {
                    ++this.progress;
                    if (this.progress >= 200) {
                        this.progress = 0;
                        this.progress = 0;
                        this.itemHandler.setStackInSlot(2, ItemStackUtil.addStack(this.itemHandler.getStackInSlot(2).m_41777_(), output.m_41777_()));
                        this.itemHandler.setStackInSlot(3, ItemStackUtil.addStack(this.itemHandler.getStackInSlot(3).m_41777_(), byproduct.m_41777_()));
                        lv.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                        this.itemHandler.getStackInSlot(0).m_41774_(1);
                        this.outputFluid.fill(fluidOut, IFluidHandler.FluidAction.EXECUTE);
                        if (!this.cachedRecipe.getInputFluid().isEmpty()) {
                            this.inputFluid.drain(fluidin.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        this.dirty = true;
                    }
                    if (this.fuel <= 0 && this.getEnergy() >= 8) {
                        this.energyStorage.extractEnergy(8, false);
                        this.isUsingEnergy = true;
                    }
                }
            } else if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.lamphelper.changeLampState(LampStates.YELLOW);
            } else {
                this.lamphelper.changeLampState(LampStates.RED);
            }
            if (this.fuel > 0) {
                --this.fuel;
                if (this.fuel == 0) {
                    this.dirty = true;
                }
            }
        } else {
            this.lamphelper.changeLampState(LampStates.WARN);
        }
        LitUtil.setLit(isLit, lv, this.f_58858_);
        this.lamphelper.lampSyncer();
        if (lv instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)lv;
            this.fluidSyncHelper.syncifneeded(serverLevel);
        }
    }

    private boolean canInsert(HeatFurnaceRecipe recipe) {
        ItemStack resultslot = this.itemHandler.getStackInSlot(2);
        ItemStack byproductslot = this.itemHandler.getStackInSlot(3);
        return !(!resultslot.m_41619_() && !ItemStackUtil.canAddStack(resultslot, recipe.getOutput()) || !byproductslot.m_41619_() && !ItemStackUtil.canAddStack(byproductslot, recipe.getByproduct()) || !FluidStackUtil.canFullyInsertToTank(recipe.getFluidOut(), this.outputFluid));
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(3000, 20, 20);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.inputFluid.setFluid(fluid1);
        this.outputFluid.setFluid(fluid2);
    }

    @Override
    public LampStates getLampStates() {
        return this.lamphelper.getLampStates();
    }

    @Override
    public void receivePacket(LampStates states) {
        this.lamphelper.receivePacket(states);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidTanksLazyOptional.invalidate();
    }
}

