/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricGeneratorAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.fluidhandlers.SimpleIOFluidHandler;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.screen.HeatGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public class HeatGeneratorBlockEntity
extends ElectricGeneratorAbstract
implements MenuProvider,
IDualTankBlock {
    private boolean dirty = true;
    private final int GENERATE_UNIT = 10;
    private final FluidTank inputFluid = new FluidTank(4000){

        protected void onContentsChanged() {
            HeatGeneratorBlockEntity.this.m_6596_();
            HeatGeneratorBlockEntity.this.dirty = true;
            HeatGeneratorBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank outputFluid = new FluidTank(4000){

        protected void onContentsChanged() {
            HeatGeneratorBlockEntity.this.m_6596_();
            HeatGeneratorBlockEntity.this.dirty = true;
            HeatGeneratorBlockEntity.this.syncFluidToClient();
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new SimpleIOFluidHandler(this.inputFluid, this.outputFluid));

    public FluidTank getInputTank() {
        return this.inputFluid;
    }

    public FluidTank getOutputTank() {
        return this.outputFluid;
    }

    public HeatGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricGeneratorAbstract>)((BlockEntityType)ModBlockEntities.HEAT_GENERATOR.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.inputFluid.readFromNBT(tag.m_128469_("InputTank"));
        this.outputFluid.readFromNBT(tag.m_128469_("OutputTank"));
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag fluidTag = new CompoundTag();
        this.inputFluid.writeToNBT(fluidTag);
        tag.m_128365_("InputTank", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.outputFluid.writeToNBT(fluidTag);
        tag.m_128365_("OutputTank", (Tag)fluidTag);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.inputFluid.getFluid().copy(), this.outputFluid.getFluid().copy()));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void serverTick() {
        FluidStack distilled;
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        boolean flag = false;
        if (this.dirty) {
            // empty if block
        }
        if (!this.inputFluid.isEmpty() && this.inputFluid.getFluidAmount() > 10 && FluidStackUtil.canFullyInsertToTank(distilled = new FluidStack(ChemiFluids.DISTILLED_WATER.getFluid(), 10), this.outputFluid)) {
            this.generateEnergy();
            this.inputFluid.drain(10, IFluidHandler.FluidAction.EXECUTE);
            this.outputFluid.fill(distilled, IFluidHandler.FluidAction.EXECUTE);
        }
        for (Direction dir : Direction.values()) {
            BlockPos nei = this.f_58858_.m_121945_(dir);
            BlockEntity neighbor = lv.m_7702_(nei);
            if (neighbor == null) continue;
            LazyOptional mayhandler = neighbor.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
            mayhandler.ifPresent(handler -> {
                FluidStack drawing = handler.drain(20, IFluidHandler.FluidAction.SIMULATE);
                if (drawing.getFluid().m_6212_(ChemiFluids.HEATED_WATER.getFluid())) {
                    this.inputFluid.fill(handler.drain(20, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
        this.dirty = flag;
        this.provideEnergy();
    }

    private void generateEnergy() {
        if (this.energyStorage.receiveEnergy(48, true) > 0) {
            this.energyStorage.receiveEnergy(48, false);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new HeatGeneratorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.heat_generator");
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 1000, 600);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.inputFluid.setFluid(fluid1);
        this.outputFluid.setFluid(fluid2);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandlerLazyOptional.invalidate();
    }
}

