/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricConsumerAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.lamp.ILampController;
import kandango.reagenica.block.entity.lamp.LampControllerHelper;
import kandango.reagenica.block.entity.lamp.LampState;
import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.item.bioreagent.BioGrowingPlate;
import kandango.reagenica.item.bioreagent.BioReagent;
import kandango.reagenica.screen.IncubatorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class IncubatorBlockEntity
extends ElectricConsumerAbstract
implements MenuProvider,
ILampController {
    private final ItemStackHandler itemHandler = new ItemStackHandler(26){

        protected void onContentsChanged(int slot) {
            IncubatorBlockEntity.this.m_6596_();
            IncubatorBlockEntity.this.dirty = true;
        }

        public boolean isItemValid(int slot, @Nullable ItemStack stack) {
            return stack != null;
        }
    };
    private boolean dirty = true;
    private boolean turbo_mode = false;
    private Random rand = new Random();
    private final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    private final LampControllerHelper<IncubatorBlockEntity> lamphelper = new LampControllerHelper<IncubatorBlockEntity>(this);

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricConsumerAbstract>)((BlockEntityType)ModBlockEntities.INCUBATOR.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
        this.turbo_mode = tag.m_128471_("Turbo");
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
        tag.m_128379_("Turbo", this.turbo_mode);
        super.m_183515_(tag);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new IncubatorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.incubator");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            // empty if block
        }
        if (lv.m_46467_() % 20L == 0L) {
            this.consumeEnergy(8);
            boolean hassome = false;
            boolean hasgrowing = false;
            for (int i = 0; i < 26; ++i) {
                BioReagent plate;
                Item item;
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (this.getEnergy() > 0) {
                    if (this.turbo_mode || this.rand.nextInt(30) == 0) {
                        ItemStack grown = this.grow(stack.m_41777_());
                        this.itemHandler.setStackInSlot(i, grown);
                    }
                } else if (this.rand.nextInt(200) == 0 && (item = stack.m_41720_()) instanceof BioReagent && !(plate = (BioReagent)item).isSterile(stack)) {
                    this.itemHandler.setStackInSlot(i, this.contaminatedPlate());
                }
                hassome = true;
                if (hasgrowing || stack.m_41720_() != ChemiItems.GROWING_PLATE.get()) continue;
                hasgrowing = true;
            }
            if (this.getEnergy() >= 9900) {
                if (hasgrowing) {
                    this.lamphelper.changeLampState(new LampStates(LampState.OFF, LampState.ON, LampState.ON));
                } else {
                    this.lamphelper.changeLampState(LampStates.GREEN);
                }
            } else if (this.getEnergy() > 0) {
                if (hasgrowing) {
                    this.lamphelper.changeLampState(LampStates.WARN);
                } else {
                    this.lamphelper.changeLampState(LampStates.GREEN);
                }
            } else if (hassome && hasgrowing) {
                this.lamphelper.changeLampState(new LampStates(LampState.BLINK, LampState.BLINK, LampState.OFF));
            } else if (hassome) {
                this.lamphelper.changeLampState(LampStates.RED);
            } else {
                this.lamphelper.changeLampState(LampStates.YELLOW);
            }
        }
        this.lamphelper.lampSyncer();
    }

    private ItemStack grow(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BioGrowingPlate) {
            BioGrowingPlate plate = (BioGrowingPlate)item;
            int growth = plate.getGrowth(stack);
            String parenttype = plate.parentType(stack);
            int speed = plate.getSpeed(stack);
            boolean sterile = plate.isSterile(stack);
            if (growth < 7) {
                if (!sterile && this.rand.nextInt(10) == 0) {
                    return this.contaminatedPlate();
                }
                BioGrowingPlate.setGrowth(stack, growth + 1);
                return stack;
            }
            int dice = this.rand.nextInt(100);
            if (parenttype.equals("Crude")) {
                if (dice < 40) {
                    return this.contaminatedPlate();
                }
                if (dice < 60) {
                    return new ItemStack((ItemLike)ChemiItems.YEAST.get());
                }
                if (dice < 80) {
                    return new ItemStack((ItemLike)ChemiItems.ORYZAE.get());
                }
                return new ItemStack((ItemLike)ChemiItems.ACETOBACTER.get());
            }
            if (parenttype.equals("Yeast")) {
                ItemStack yeast = new ItemStack((ItemLike)ChemiItems.YEAST.get());
                BioReagent.setStats(yeast, this.modify(speed), sterile);
                return yeast;
            }
            if (parenttype.equals("Oryzae")) {
                ItemStack oryzae = new ItemStack((ItemLike)ChemiItems.ORYZAE.get());
                BioReagent.setStats(oryzae, this.modify(speed), sterile);
                return oryzae;
            }
            if (parenttype.equals("Acetobacter")) {
                ItemStack aceto = new ItemStack((ItemLike)ChemiItems.ACETOBACTER.get());
                BioReagent.setStats(aceto, this.modify(speed), sterile);
                return aceto;
            }
            return this.contaminatedPlate();
        }
        return stack;
    }

    private ItemStack contaminatedPlate() {
        ItemStack contaminated = new ItemStack((ItemLike)ChemiItems.CONTAMINATED_PLATE.get());
        BioReagent.setColor(contaminated, this.rand.nextInt(0xFFFFFF) | 0xFF000000);
        return contaminated;
    }

    private int modify(int original) {
        return Mth.m_14045_((int)(original + this.rand.nextInt(3) - 1), (int)0, (int)30);
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(10000, 200, 200);
    }

    @Override
    public LampStates getLampStates() {
        return this.lamphelper.getLampStates();
    }

    @Override
    public void receivePacket(LampStates states) {
        this.lamphelper.receivePacket(states);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }
}

