/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.LeadBattery;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricGeneratorAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.block.entity.electrical.Handlers.ConsumerEnergyHandler;
import kandango.reagenica.block.entity.electrical.Handlers.GeneratorEnergyHandler;
import kandango.reagenica.screen.LeadBatteryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class LeadBatteryBlockEntity
extends ElectricGeneratorAbstract
implements MenuProvider {
    private final LazyOptional<IEnergyStorage> energyInLazyOptional = LazyOptional.of(() -> new ConsumerEnergyHandler(this.energyStorage));
    private final LazyOptional<IEnergyStorage> energyOutLazyOptional = LazyOptional.of(() -> new GeneratorEnergyHandler(this.energyStorage));

    public LeadBatteryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricGeneratorAbstract>)((BlockEntityType)ModBlockEntities.LEAD_BATTERY.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setfromtag(tag.m_128469_("Electric"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Electric", (Tag)this.energyStorage.serializetotag());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            Direction facing = BlockUtil.getStatus(this.m_58900_(), LeadBattery.FACING).orElse(Direction.NORTH);
            if (side == facing.m_122424_()) {
                return this.energyOutLazyOptional.cast();
            }
            return this.energyInLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyInLazyOptional.invalidate();
        this.energyOutLazyOptional.invalidate();
    }

    @Override
    public void serverTick() {
        this.provideEnergy();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new LeadBatteryMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.lead_battery");
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(300000, 1000, 1000);
    }
}

