/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.packet.IDualTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public abstract class PipeAbstractBlockEntity
extends BlockEntity
implements IDualTankBlock,
ITickableBlockEntity {
    private final Set<Direction> inputDirs = new HashSet<Direction>();
    private final FluidTank internalFluid = new FluidTank(100){

        protected void onContentsChanged() {
            PipeAbstractBlockEntity.this.m_6596_();
            PipeAbstractBlockEntity.this.syncFluidToClient();
        }
    };
    private final FluidTank internalFluidBuf = new FluidTank(100){

        protected void onContentsChanged() {
            PipeAbstractBlockEntity.this.m_6596_();
            PipeAbstractBlockEntity.this.syncFluidToClient();
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.internalFluid);
    private Status beat = Status.SLEEP;
    private int waittick = 0;
    private boolean dirty = true;

    public FluidStack getFluid() {
        FluidStack stack1 = this.internalFluid.getFluid();
        FluidStack stack2 = this.internalFluidBuf.getFluid();
        return new FluidStack(stack1.getFluid(), stack1.getAmount() + stack2.getAmount());
    }

    public PipeAbstractBlockEntity(BlockEntityType<? extends PipeAbstractBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncDualFluidTanksPacket(this.f_58858_, this.internalFluid.getFluid().copy(), this.internalFluidBuf.getFluid().copy()));
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.internalFluid.readFromNBT(tag.m_128469_("Internal"));
        this.internalFluidBuf.readFromNBT(tag.m_128469_("InternalBuf"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        CompoundTag fluidTag = new CompoundTag();
        this.internalFluid.writeToNBT(fluidTag);
        tag.m_128365_("Internal", (Tag)fluidTag);
        fluidTag = new CompoundTag();
        this.internalFluidBuf.writeToNBT(fluidTag);
        tag.m_128365_("InternalBuf", (Tag)fluidTag);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void receivePacket(FluidStack fluid1, FluidStack fluid2) {
        this.internalFluid.setFluid(fluid1);
        this.internalFluidBuf.setFluid(fluid2);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void setInSide(Direction dir) {
        this.inputDirs.add(dir);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
        }
        if (this.beat == Status.SLEEP) {
            if (!this.internalFluid.isEmpty()) {
                this.beat = Status.IDLE;
                this.waittick = 0;
            }
        } else if (this.beat == Status.ABSORB) {
            int filled = this.internalFluid.fill(this.internalFluidBuf.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            if (filled != this.internalFluidBuf.getFluidAmount()) {
                throw new IllegalStateException("Fluid merge failed at " + this.m_58899_().toString());
            }
            this.internalFluidBuf.setFluid(FluidStack.EMPTY);
            this.beat = Status.ACT;
            if (this.internalFluid.isEmpty()) {
                this.beat = Status.SLEEP;
                this.inputDirs.clear();
            }
        } else if (this.beat == Status.ACT) {
            float distribute_rate;
            if (this.internalFluid.isEmpty()) {
                this.beat = Status.SLEEP;
                return;
            }
            HashMap handlers = new HashMap();
            HashMap demands = new HashMap();
            for (Direction dir : Direction.values()) {
                if (this.inputDirs.contains(dir)) continue;
                this.isValidConnection(dir).ifPresent(handler -> {
                    handlers.put(dir, handler);
                    demands.put(dir, this.getInputtableamount((IFluidHandler)handler, this.internalFluid.getFluid()));
                });
            }
            int demand = demands.values().stream().mapToInt(x -> x).sum();
            if (demand == 0) {
                this.inputDirs.clear();
            }
            if ((distribute_rate = (float)Math.min(this.internalFluid.getFluidAmount(), this.maxTransfer()) / (float)demand) > 1.0f) {
                distribute_rate = 1.0f;
            }
            for (Direction dir : Direction.values()) {
                IFluidHandler handler2 = (IFluidHandler)handlers.get(dir);
                if (handler2 == null) continue;
                int amount = (int)Math.ceil((float)((Integer)demands.get(dir)).intValue() * distribute_rate);
                int finalamount = Math.min(amount, this.internalFluid.getFluidAmount());
                handler2.fill(new FluidStack(this.internalFluid.getFluid().getFluid(), finalamount), IFluidHandler.FluidAction.EXECUTE);
                this.internalFluid.drain(finalamount, IFluidHandler.FluidAction.EXECUTE);
                BlockEntity be = lv.m_7702_(this.m_58899_().m_121945_(dir));
                if (!(be instanceof PipeAbstractBlockEntity)) continue;
                PipeAbstractBlockEntity pipe = (PipeAbstractBlockEntity)be;
                pipe.setInSide(dir.m_122424_());
            }
            this.beat = Status.IDLE;
        } else if (this.beat == Status.IDLE) {
            ++this.waittick;
            if (this.waittick >= 8) {
                this.beat = Status.ABSORB;
                this.waittick = 0;
            }
        }
    }

    private LazyOptional<IFluidHandler> isValidConnection(Direction dir) {
        Level lv = this.f_58857_;
        if (lv == null) {
            return LazyOptional.empty();
        }
        BlockPos here = this.m_58899_();
        BlockEntity relative = lv.m_7702_(here.m_121945_(dir));
        if (relative == null) {
            return LazyOptional.empty();
        }
        if (relative instanceof PipeAbstractBlockEntity && relative.getClass() != this.getClass()) {
            return LazyOptional.empty();
        }
        return relative.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
    }

    private int getInputtableamount(IFluidHandler handler, FluidStack fluid) {
        return handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
    }

    protected abstract int maxTransfer();

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandlerLazyOptional.invalidate();
    }

    public static enum Status {
        SLEEP,
        ABSORB,
        ACT,
        IDLE;

    }
}

