/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.PumpChemistry;
import kandango.reagenica.block.entity.ITickableBlockEntity;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.fluidhandlers.NopFluidHandler;
import kandango.reagenica.packet.ISingleTankBlock;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncFluidPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public class PumpBlockEntity
extends BlockEntity
implements ISingleTankBlock,
ITickableBlockEntity {
    private final FluidTank internalFluid = new FluidTank(100){

        protected void onContentsChanged() {
            PumpBlockEntity.this.m_6596_();
            PumpBlockEntity.this.syncFluidToClient();
        }
    };
    private final LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.of(() -> new NopFluidHandler(this.internalFluid));

    public FluidStack getFluid() {
        return this.internalFluid.getFluid().copy();
    }

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PUMP.get(), pos, state);
    }

    private void syncFluidToClient() {
        Level lv = this.f_58857_;
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.f_58858_)), (Object)new SyncFluidPacket(this.f_58858_, this.internalFluid.getFluid().copy()));
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.internalFluid.readFromNBT(tag.m_128469_("Internal"));
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        CompoundTag fluidTag = new CompoundTag();
        this.internalFluid.writeToNBT(fluidTag);
        tag.m_128365_("Internal", (Tag)fluidTag);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        Direction facing;
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == (facing = (Direction)this.m_58900_().m_61143_((Property)PumpChemistry.FACING)) || side == facing.m_122424_())) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void receivePacket(FluidStack fluid1) {
        this.internalFluid.setFluid(fluid1);
    }

    @Override
    public void serverTick() {
        BlockEntity pushingsubj;
        Direction pushside = (Direction)this.m_58900_().m_61143_((Property)PumpChemistry.FACING);
        Direction pullside = pushside.m_122424_();
        BlockPos pos = this.m_58899_();
        Level lv = this.m_58904_();
        if (lv == null) {
            return;
        }
        BlockEntity pullingsubj = lv.m_7702_(pos.m_121945_(pullside));
        if (pullingsubj != null) {
            pullingsubj.getCapability(ForgeCapabilities.FLUID_HANDLER, pullside.m_122424_()).ifPresent(handler -> this.pull((IFluidHandler)handler));
        }
        if ((pushingsubj = lv.m_7702_(pos.m_121945_(pushside))) != null) {
            pushingsubj.getCapability(ForgeCapabilities.FLUID_HANDLER, pushside.m_122424_()).ifPresent(handler -> this.push((IFluidHandler)handler));
        }
    }

    private void pull(IFluidHandler handler) {
        FluidStack pullingstack = handler.drain(20, IFluidHandler.FluidAction.SIMULATE);
        int pullable = this.internalFluid.fill(pullingstack, IFluidHandler.FluidAction.SIMULATE);
        if (pullable != 0) {
            FluidStack pulledstack = handler.drain(pullable, IFluidHandler.FluidAction.EXECUTE);
            this.internalFluid.fill(pulledstack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void push(IFluidHandler handler) {
        int pushable = handler.fill(this.internalFluid.getFluid(), IFluidHandler.FluidAction.SIMULATE);
        if (pushable != 0) {
            FluidStack pushing = this.internalFluid.getFluid().copy();
            pushing.setAmount(Math.min(pushing.getAmount(), 20));
            int pushed = handler.fill(pushing, IFluidHandler.FluidAction.EXECUTE);
            this.internalFluid.drain(pushed, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler.invalidate();
    }
}

