/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.electrical;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.block.entity.ModBlockEntities;
import kandango.reagenica.block.entity.electrical.ElectricGeneratorAbstract;
import kandango.reagenica.block.entity.electrical.ElectricStorage;
import kandango.reagenica.screen.SolarPowerGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SolarPowerGeneratorBlockEntity
extends ElectricGeneratorAbstract
implements MenuProvider {
    private int powerTick = 0;
    private boolean isBlocked = false;

    public SolarPowerGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ElectricGeneratorAbstract>)((BlockEntityType)ModBlockEntities.GENERATOR_SOLAR.get()), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    @Override
    public void serverTick() {
        Level lv = this.f_58857_;
        if (lv == null) {
            return;
        }
        if (this.powerTick < 10) {
            ++this.powerTick;
        } else {
            this.powerTick = 0;
            boolean bl = this.isBlocked = !lv.m_45527_(this.f_58858_.m_7494_());
            if (!this.isBlocked) {
                this.generateEnergy(lv);
            }
        }
        this.provideEnergy();
    }

    private void generateEnergy(@Nonnull Level lv) {
        int energyRate = 0;
        boolean isClear = !lv.m_46471_() && !lv.m_46470_();
        int dayTime = (int)(lv.m_46468_() % 24000L);
        energyRate = dayTime < 12000 ? 10 : (dayTime < 13000 ? (13000 - dayTime) / 100 : (dayTime < 23000 ? 0 : (dayTime - 23000) / 100));
        if (!isClear) {
            energyRate /= 2;
        }
        this.energyStorage.receiveEnergy(energyRate, false);
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean value) {
        this.isBlocked = value;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new SolarPowerGeneratorMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.reagenica.solar_power_generator");
    }

    @Override
    protected ElectricStorage energyStorageProvider() {
        return new ElectricStorage(3000, 1000, 400);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
    }
}

