/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.fluidhandlers;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SimpleIOFluidHandler
implements IFluidHandler {
    private final FluidTank tankin;
    private final FluidTank tankout;

    public SimpleIOFluidHandler(FluidTank tankin, FluidTank tankout) {
        this.tankin = tankin;
        this.tankout = tankout;
    }

    public int getTanks() {
        return 2;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getTank(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getTank(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tankin.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tankout.drain(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tankout.drain(maxDrain, action);
    }

    private FluidTank getTank(int index) {
        if (index == 0) {
            return this.tankin;
        }
        if (index == 1) {
            return this.tankout;
        }
        throw new IndexOutOfBoundsException();
    }
}

