/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.fluidsyncer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncDualFluidTanksPacket;
import kandango.reagenica.packet.SyncFluidPacket;
import kandango.reagenica.packet.SyncQuadFluidTanksPacket;
import kandango.reagenica.screen.ChemistryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;

public class FluidSyncHelper {
    private final List<FluidTank> tanks;
    private List<FluidTank> lasttanks;
    private final BlockPos pos;
    private final SyncType type;
    private int tick = 60;

    public FluidSyncHelper(BlockPos pos, SyncType type, FluidTank ... tanks) {
        this.tanks = Arrays.asList(tanks);
        this.save();
        this.pos = pos;
        this.type = type;
    }

    public void syncifneeded(ServerLevel lv) {
        if (this.tick == 60) {
            this.tick = 1;
            this.syncToChunk(lv);
        } else {
            ++this.tick;
            if (this.shouldSync()) {
                this.syncToChunk(lv);
            } else {
                for (ServerPlayer player : lv.m_6907_()) {
                    ChemistryMenu menu;
                    Object be;
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (!(abstractContainerMenu instanceof ChemistryMenu) || (be = (menu = (ChemistryMenu)abstractContainerMenu).getBlockEntity()) == null || !be.m_58899_().equals((Object)this.pos)) continue;
                    this.syncToPlayer(lv, player);
                }
            }
        }
    }

    private boolean shouldSync() {
        for (int i = 0; i < this.tanks.size(); ++i) {
            if (!this.isSignificantChange(this.tanks.get(i), this.lasttanks.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isSignificantChange(FluidTank tank1, FluidTank tank2) {
        int max;
        int f2amount;
        if (this.type == SyncType.GUIONLY) {
            return false;
        }
        FluidStack f1 = tank1.getFluid();
        FluidStack f2 = tank2.getFluid();
        if (!(!f1.isEmpty() && !f2.isEmpty() || f1.isEmpty() && f2.isEmpty())) {
            return true;
        }
        if (!f1.isFluidEqual(f2)) {
            return true;
        }
        if (this.type == SyncType.ALLNOTHING) {
            return false;
        }
        int f1amount = f1.getAmount();
        int diff = f1amount - (f2amount = f2.getAmount());
        return diff > (max = tank1.getCapacity()) / 20 || diff < -max / 20;
    }

    private void save() {
        this.lasttanks = new ArrayList<FluidTank>(this.tanks.size());
        for (FluidTank tank : this.tanks) {
            this.lasttanks.add(new FluidTank(tank.getCapacity()));
            this.lasttanks.get(this.lasttanks.size() - 1).setFluid(tank.getFluid().copy());
        }
    }

    private void syncToChunk(ServerLevel lv) {
        switch (this.tanks.size()) {
            case 1: {
                ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.pos)), (Object)new SyncFluidPacket(this.pos, this.tanks.get(0).getFluid().copy()));
                break;
            }
            case 2: {
                ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.pos)), (Object)new SyncDualFluidTanksPacket(this.pos, this.tanks.get(0).getFluid().copy(), this.tanks.get(1).getFluid().copy()));
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Triple tank is not supported now.");
            }
            case 4: {
                ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(this.pos)), (Object)new SyncQuadFluidTanksPacket(this.pos, this.tanks.get(0).getFluid().copy(), this.tanks.get(1).getFluid().copy(), this.tanks.get(2).getFluid().copy(), this.tanks.get(3).getFluid().copy()));
                break;
            }
            default: {
                throw new IllegalStateException("Tank count was invalid.");
            }
        }
        this.save();
    }

    private void syncToPlayer(ServerLevel lv, ServerPlayer player) {
        switch (this.tanks.size()) {
            case 1: {
                ModMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncFluidPacket(this.pos, this.tanks.get(0).getFluid().copy()));
                break;
            }
            case 2: {
                ModMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDualFluidTanksPacket(this.pos, this.tanks.get(0).getFluid().copy(), this.tanks.get(1).getFluid().copy()));
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Triple tank is not supported now.");
            }
            case 4: {
                ModMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncQuadFluidTanksPacket(this.pos, this.tanks.get(0).getFluid().copy(), this.tanks.get(1).getFluid().copy(), this.tanks.get(2).getFluid().copy(), this.tanks.get(3).getFluid().copy()));
                break;
            }
            default: {
                throw new IllegalStateException("Tank count was invalid.");
            }
        }
    }

    public static enum SyncType {
        ALWAYS,
        GUIONLY,
        ALLNOTHING;

    }
}

